#!/usr/local/bin/zasm --z180 -o original/
;*****************************************
;*  HD64180 PROGRAM FOR COUNTER MASTER	 *
;*	    PROGRAMED  ADO-POS-SYSTEM	 *
;*			     1991.7.10	 *
;*****************************************

#target rom

	; INTERNAL I/O MAP
;
CNTLA0	EQU	00H
CNTLA1	EQU	01H
CNTLB0	EQU	02H
CNTLB1	EQU	03H
STAT0	EQU	04H
STAT1	EQU	05H
TDR0	EQU	06H
TDR1	EQU	07H
RDR0	EQU	08H
RDR1	EQU	09H
	;
CNTR	EQU	0AH
TRDR	EQU	0BH
	;
TMDR0L	EQU	0CH
TMDR0H	EQU	0DH
RLDR0L	EQU	0EH
RLDR0H	EQU	0FH
TCR	EQU	10H
TMDR1L	EQU	14H
TMDR1H	EQU	15H
RLDR1L	EQU	16H
RLDR1H	EQU	17H
	;
FRC	EQU	18H
	;
SAR0L	EQU	20H
SAR0H	EQU	21H
SAR0B	EQU	22H
DAR0L	EQU	23H
DAR0H	EQU	24H
DAR0B	EQU	25H
BCR0L	EQU	26H
BCR0H	EQU	27H
MAR1L	EQU	28H
MAR1H	EQU	29H
MAR1B	EQU	2AH
IAR1L	EQU	2BH
IAR1H	EQU	2CH
BCR1L	EQU	2EH
BCR1H	EQU	2FH
DSTAT	EQU	30H
DMODE	EQU	31H
DCNTL	EQU	32H
	;
IL	EQU	33H
ITC	EQU	34H
	;
RCR	EQU	36H
	;
CBR	EQU	38H
BBR	EQU	39H
CBAR	EQU	3AH
	;
ICR	EQU	3FH
	;
	;EXTERNAL I/O ADDRESS
	;----------------------------------------
	;I/O PORT ADDRESS DEFINE
	;
DATA1:	EQU	70H	;PORT1 DATA
STAT2:	EQU	71H	;PORT1 STATE
COMD1:	EQU	71H	;8251 COMMAND PORT1
	;
PORTA:	EQU	80H	;KEY OUT
PORTB:	EQU	81H	;KEY OUT
PORTC:	EQU	82H	;KEY IN
PORTD:	EQU	83H	;CONTROL WORD
	;
PPA:	EQU	90H	;PARALELL BUS
TIMSET: EQU	91H	;TIME SET
FUNKEY: EQU	91H	;FUNTION KEY
GKEY:	EQU	91H	;GKEY
PPC:	EQU	92H	;PARALELL STB BUSY
PPD:	EQU	93H	;CONTROL WORD
	;
LATCH:	EQU    0A0H	;SEGMENT COMMON
	;
PTA:	EQU    0C0H	;TABLE MONITOR
PTB:	EQU    0C1H	;
PTC:	EQU    0C2H	;
PTD:	EQU    0C3H	;CONTROL WORD
	;
SEVEN:	EQU    0D0H	;SEVEN SEGMENT
	;
BELLON: EQU    0E0H	;BUZZER ON / OFF
	;
POTST:	EQU    0F0H
	;
STK:	EQU	0FFFFH	;STACK ADDRESS
	;------------------------------------------------
	; RAM AREA DEFINE ( 62256 MAP = 10000H to 18000H )
;	ORG	8000H
#data data,0x8000
KEYDATA:DS	1	;PUSH KEY DATA
KEYFLG: DS	1	;KEY ON/OFF FLAG  (0FH)
BELLFLG:DS	1	;BUZZER ON/OFF	  (0FH)
JUMPFLG:DS	1	;JUMP SERCH FLAG  (0FH)
DISPFLG:DS	1	;PASSWORD SET AT  (0FH)
TMOVFLG:DS	1	;TABLE MOVE AT	  (0FH)
MENPUN: DS	1	;MENU PUNCH AT	  (0FH)
TABPUN: DS	1	;TABLE PUNCH AT   (0FH)
SETFLG: DS	1	;MENU SET FLAG	  (0FH)
MENUFLG:DS	1	;TABLE OF MENU AT (0FH)
TMEFLG: DS	1	;TOTAL MENU AT	  (0FH)
FUNFLG: DS	1	;FUNTION KEY
GIVEFLG:DS	1	;
GIVACT: DS	1	;
GIVACT1:DS	1	;
GPASS:	DS	1	;
GIVMDA: DS	5	;
JJBCBF: DS	2	;
CLEMUX: DS	1	;
CLEFLG: DS	1	;MENU SET AT CLEAR(0FH)
CRFLG:	DS	1	;CREDIT FLG	  (0FH)
FAFLG:	DS	1	;FAPAY FLG	  (0FH)
MUXFLG: DS	1	;MULTI FLG	  (0FH)
ADDR:	DS	2	;
PASFLG: DS	1	;TOTAL INCOME DISPLAY FLG PASS WORD
ACTFLG: DS	1	;ACTION ON/OFF
LAFLG:	DS	1	;TABLE SERCH SET LAMP ON/OFF (0FH)
PAYFLG: DS	1	;PAY KEY (0FH)
MMFLG:	DS	1	;
JJFLG:	DS	1	;JUNG JUNG FLAG
CIRFLG: DS	1	;1 ROTATE FLG PAY
CNRFLG: DS	1
CIRNO:	DS	1
FLASH:	DS	4	;FLASH ON/OFF	  (0FH)
PRONFLG:DS	1	;
BUAFLG: DS	1
BUBFLG: DS	1
BUCFLG: DS	1
DCFLG:	DS	1
	;----------------------------
	;PRINT CONTROL FLAGE
TRANBF: DS	50	;50:TRANSFER BUFFER
TBYTE:	DS	2	;TRANSFER BYTE
PRTIME: DS	18	;PRINT TIME CONVETER
PRYNG:	DS	2	;YOUNG SU JEENG NO
JJNO:	DS	2	;JEONG JEONG SU NO
PRJUN:	DS	4	;PRINT JUN PYO
PRCHNO: DS	4	;YOUNG SU JEENG CHAIR NO.
PRYUNG: DS	500	;YUNG SU KUM ACK AREA 4 * 125 = 500
PRYUBF: DS	2	;CONVERT BF.
PRDEBF: DS	2	;
PRHLBF: DS	2	;
PRBCA:	DS	2
PRBCB:	DS	2
JNOBF:	DS	2	;
PRWORK: DS	8
PRTEM:	DS	4	;
PRDC:	DS	4	;DISCOUNT BUFFER
PRAMT:	DS	4	;PRINT AMOUNT
	;----------------------------
TPAYFLG:DS	1	;TOTAL INCOME AT  (0FH)
INTCNT: DS	1	;INTERRUPT COUNT
INCNT:	DS	2	;
INFLG:	DS	1	;MENU HIT FLG
MENUCNT:DS	1	;MENU COUNT BUFFER
LACNT:	DS	1	;LAMP COUNT BUFFER
LEDCNT: DS	1	;LED COUNT NORMAL RESET
CPDBF:	DS	1	;KEY SERCH HL INC. BUFFER
CPDBF1: DS	2	;
STKBF:	DS	2	;STACK BUFFER
MOVFLG: DS	2	;MOVEMENT RESISTER FLAG
DATA:	DS	6	;DISPLAY DATA
EXDATA: DS	2	;DATA+4 DATA+5 EXCHANGE
LEDS:	DS	11	;EIGHT DIGIT DATA BUFFER
BLANK:	DS	1	;NORMAL RESET
	;----------------------------------------------
ADDFLA: DS	3	;ADDTION FLGA
PRWON:	DS	4	;PRINTING PAY WON
MPB:	DS	380	;MENU PRINT BUFFER 125 * 3 = 750
MPB1:	DS	380
MUXBF:	DS	4	;
WRKBF:	DS	12	;DISPLAY WORKING BUFFER
WORK:	DS	254	;WORK BUFFER 2 * 125 + 4
TEMBF:	DS	254	;TEM. BUFFER
INCOME: DS	254	;TOTAL INCOME BUFF
PDISCO: DS	5	;DISCOUNT TOTAL
PAMOUN: DS	5	;YOUNG SU JEENG
TOTAL:	DS	254	;TOTAL BUFFER
CDBUFF: DS	254	;CREDIT TOTAL INCOME
FABUFF: DS	254	;FAPAY INCOME
LABUFF: DS	13	;LAMP DISPLAY BUFFER
TIMGUM: DS	68	;4BYTE * 17TIME
	;----------------------------------------------
TAB1:	DS	25146	;TABLE NUMBER 1 TO 99*254
POWOFF: DS	100	;POWER OFF COUNT BUFFER
PWRON:	DS	1	;POWER ON / OFF COUNT
JJDATA: DS	1600	;JUNG JUNG COUNT BUFFER 8 * 200
AREA:	DS	4	;DATA AREA
GIVEON: DS	1
JUNNO:	DS	2	;JUNPYO INC. BUFFER 1 TO 999
	;----------------------------------------------
DATE:	DS	6	;DATE.MOUNTH.YEAR
DTIME:	DS	6	;1 - 24 HOUR CONVTER
CLKO:	DS	1	;
CLOCK:	DS	6	;1 - 12 HOUR
HOUFLG: DS	1	;CLOCK DISP
MONFLG: DS	1	;MOUNTH DISP
APFLG:	DS	1	;AM / PM FLG
	;----------------------------------------------
MENU1:	DS	3
MENU2:	DS	3
MENU3:	DS	3
MENU4:	DS	3
MENU5:	DS	3
MENU6:	DS	3
MENU7:	DS	3
MENU8:	DS	3
MENU9:	DS	3
MENU10: DS	3
MENU11: DS	3
MENU12: DS	3
MENU13: DS	3
MENU14: DS	3
MENU15: DS	3
MENU16: DS	3
MENU17: DS	3
MENU18: DS	3
MENU19: DS	3
MENU20: DS	3
MENU21: DS	3
MENU22: DS	3
MENU23: DS	3
MENU24: DS	3
MENU25: DS	3
MENU26: DS	3
MENU27: DS	3
MENU28: DS	3
MENU29: DS	3
MENU30: DS	3
MENU31: DS	3
MENU32: DS	3
MENU33: DS	3
MENU34: DS	3
MENU35: DS	3
MENU36: DS	3
MENU37: DS	3
MENU38: DS	3
MENU39: DS	3
MENU40: DS	3
MENU41: DS	3
MENU42: DS	3
MENU43: DS	3
MENU44: DS	3
MENU45: DS	3
MENU46: DS	3
MENU47: DS	3
MENU48: DS	3
MENU49: DS	3
MENU50: DS	3
MENU51: DS	3
MENU52: DS	3
MENU53: DS	3
MENU54: DS	3
MENU55: DS	3
MENU56: DS	3
MENU57: DS	3
MENU58: DS	3
MENU59: DS	3
MENU60: DS	3
MENU61: DS	3
MENU62: DS	3
MENU63: DS	3
MENU64: DS	3
MENU65: DS	3
MENU66: DS	3
MENU67: DS	3
MENU68: DS	3
MENU69: DS	3
MENU70: DS	3
MENU71: DS	3
MENU72: DS	3
MENU73: DS	3
MENU74: DS	3
MENU75: DS	3
MENU76: DS	3
MENU77: DS	3
MENU78: DS	3
MENU79: DS	3
MENU80: DS	3
MENU81: DS	3
MENU82: DS	3
MENU83: DS	3
MENU84: DS	3
MENU85: DS	3
MENU86: DS	3
MENU87: DS	3
MENU88: DS	3
MENU89: DS	3
MENU90: DS	3
MENU91: DS	3
MENU92: DS	3
MENU93: DS	3
MENU94: DS	3
MENU95: DS	3
MENU96: DS	3
MENU97: DS	3
MENU98: DS	3
MENU99: DS	3
MENU100:DS	3
MENU101:DS	3
MENU102:DS	3
MENU103:DS	3
MENU104:DS	3
MENU105:DS	3
MENU106:DS	3
MENU107:DS	3
MENU108:DS	3
MENU109:DS	3
MENU110:DS	3
MENU111:DS	3
MENU112:DS	3
MENU113:DS	3
MENU114:DS	3
MENU115:DS	3
MENU116:DS	3
MENU117:DS	3
MENU118:DS	3
MENU119:DS	3
MENU120:DS	3
MENU121:DS	3
MENU122:DS	3
MENU123:DS	3
MENU124:DS	3
MENU125:DS	3
MENU126:DS	2
	;
;	*******************************
;	*	MAIN PROGRAM	      *
;	*******************************
	;
#code rom,0	
;	ORG	0000
	;
	DI
	;
	LD	HL,2200H
STLP:	DEC	HL
	LD	A,H
	OR	L
	JR	NZ,STLP
	;
	JP	INIT
	;
COMMON: DB	00H,10H,20H,30H
	DB	40H,50H,60H,70H
	DB	80H,90H,0A0H,0F0H
	;----------------------------------------------
COMA:	DB	1,2,4,8,10H,20H,40H,80H
	DB	1,2,4,8,10H,20H,40H,80H
	;----------------------------------------------
TABLE:	DB	3FH,06H,5BH,4FH ;DISPLAY CONVERT
	DB	66H,6DH,7DH,07H
	DB	7FH,6FH,3FH
	DB	79H,54H,5EH,3FH; B=E , C=n , D=d  End.
	;----------------------------------------------
INIT:	LD	A,8AH		;PARALELL / TIMESET
	OUT	(PPD),A
	LD	A,8AH
	OUT	(PPD),A
	;
	LD	A,80H
	OUT	(PTD),A 	;TABLE MONITOR
	LD	A,80H
	OUT	(PTD),A
	;
	LD	A,89H
	OUT	(PORTD),A
	LD	A,89H
	OUT	(PORTD),A
	;
	LD	A,0		;8251 SET
	OUT	(COMD1),A
	OUT	(COMD1),A
	LD	A,4EH
	OUT	(COMD1),A
	OUT	(COMD1),A
	LD	A,23H
	OUT	(COMD1),A
	OUT	(COMD1),A
	;
	LD	A,0FFH
	OUT	(PPC),A
	LD	A,0
	OUT	(BELLON),A
	LD	B,12
	LD	HL,DATE
CLDTM:	LD	(HL),A
	INC	HL
	DJNZ	CLDTM
	;--------------------------------------------------
INITA:	LD	SP,STK		;MEMORY CLEAR 2000H - FFFFH
	LD	HL,INCOME-1
INLOOP: XOR	A
	LD	(HL),A
	DEC	HL
	LD	A,H
	CP	80H
	JR	NZ,INLOOP
	LD	A,L
	OR	A
	JR	NZ,INLOOP
	;
	CALL	READ
	CALL	CONTM
	;
	LD	A,(PWRON)
	OR	A
	JR	NZ,PWSRT1
	LD	A,1
	LD	(PWRON),A
	;
PWSRT1: LD	HL,POWOFF
	LD	BC,30
PWLP1:	LD	A,(HL)
	OR	A
	JR	Z,PWONIN
	INC	HL
	INC	HL
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,PWLP1
	JP	TIMRED
	;
PWONIN: LD	A,(PWRON)
	LD	(HL),A
	INC	HL
	LD	A,(DTIME+1)
	LD	(HL),A
	INC	HL
	LD	A,(DTIME)
	LD	(HL),A
	;
TIMRED: LD	A,(PWRON)
	ADD	A,1
	DAA
	LD	(PWRON),A
	;
	;------------------------------
	CALL	INITVEC
	CALL	INITAS0
	CALL	SETAS0
	CALL	INITAS1
	CALL	SETAS1
	CALL	SETTIM
	;
	LD	A,0
	LD	C,0BEH
	OUT	(C),A
	LD	A,08
	LD	C,0BDH
	OUT	(C),A
	;
	LD	A,0
	LD	(CNRFLG),A
	;
	LD	HL,MENU1
	LD	B,125
;SERT:	 LD	 A,00
;	 LD	 (HL),A
;	 INC	 HL
;	 LD	 A,10H
;	 LD	 (HL),A
;	 INC	 HL
;	 LD	 A,00
;	 LD	 (HL),A
;	 INC	 HL
;	 DJNZ	 SERT
	;------------------------------
	JP	CLEAR
	;------------------------------
DISP:	EI			;DISPLAY ROUTINE
	LD	SP,STK
	;
	LD	A,8
	LD	HL,LABUFF+12
	OR	(HL)
	LD	(HL),A
	;
	XOR	A		;ENABLE INTERRUPT
	LD	(ACTFLG),A
	;
	INC	A
	LD	(CPDBF),A
	;
WAKEY:	LD	HL,CLKO
	LD	A,(HL)
	SUB	10
	JR	C,SERCH2
	LD	(HL),A
	IN	A,(TIMSET)
	LD	E,A
	BIT	0,A
	JR	NZ,SERCH1
	BIT	1,E
	CALL	Z,WRIT1
	BIT	2,E
	CALL	Z,WRIT2
	BIT	3,E
	CALL	Z,WRIT3
	BIT	4,E
	CALL	Z,WRIT4
	BIT	5,E
	CALL	Z,WRIT5
	;
	JR	SERCH2
	;
SERCH1: BIT	1,E
	CALL	Z,TMDIS1
	BIT	2,E
	CALL	Z,TMDIS1
	BIT	3,E
	CALL	Z,TMDIS2
	BIT	4,E
	CALL	Z,TMDIS2
	BIT	5,E
	CALL	Z,TMDIS2
	;
SERCH2: LD	A,(HOUFLG)
	OR	A
	JR	Z,DISA
	LD	DE,DTIME
	CALL	CONVT
	LD	B,5
	JR	DISB
	;-----------------------
DISA:	LD	A,(MONFLG)
	OR	A
	JP	Z,DISC
	;
	LD	DE,DATE
	CALL	CONVT
	LD	B,2
	;
DISB:	LD	DE,WRKBF+7
	CALL	CONVL
	;
	LD	B,1
	LD	DE,WRKBF+3
	CALL	CONVL
	;
	LD	B,1
	LD	DE,WRKBF+1
	CALL	CONVL
	;
	LD	DE,WRKBF+6
	LD	HL,WRKBF+5
	LD	B,4
	CALL	MOVX
	;
	LD	A,40H
	LD	(WRKBF+2),A
	;
STRT1:	LD	HL,(FLASH)
	;
	LD	DE,65136
	ADD	HL,DE
	JR	NC,STRT11
	XOR	A
	LD	(WRKBF+2),A
	LD	HL,(FLASH)
	LD	DE,64736
	ADD	HL,DE
	JR	NC,STRT11
	LD	(FLASH),HL
	;
STRT11: LD	HL,WRKBF+7
	LD	DE,LEDS+7
	LD	B,8
	CALL	MOVX
	;
	LD	A,(ACTFLG)
	OR	A
	JP	Z,DISP
	;
	LD	HL,KEYDATA
	LD	A,(HL)		;KEY BOARD JUMP TABLE
	CP	10H
	JP	Z,CLEAR 	;DISPLAY CLEAR
	JP	DISP
	;
DISC:	LD	DE,DATA
	CALL	CONVT
	;
	LD	A,(TMOVFLG)
	OR	A
	JR	NZ,SPDISP
	LD	A,(MENUFLG)
	OR	A
	JR	NZ,SPDISP
	LD	A,(TMEFLG)
	OR	A
	JR	NZ,SPDISP
	LD	A,(JUMPFLG)
	OR	A
	JR	NZ,SPDISP
	LD	A,(INFLG)
	OR	A
	JR	NZ,SPDISP
	;
	CALL	CONVTA
	LD	B,3
	LD	DE,WRKBF+10
	CALL	CONVL
	JR	LEDON
	;
SPDISP: LD	DE,WRKBF+3
	LD	B,3
	CALL	CONVL
	LD	B,4
	LD	DE,WRKBF+7
	CALL	CONVL
	LD	B,3
	LD	DE,WRKBF+10
	CALL	CONVL
	;
LEDON:	LD	DE,LAFLG
	LD	A,(DE)
	LD	HL,WRKBF
	RES	7,(HL)
	OR	A
	JR	Z,MESET
	LD	A,(DATA+5)
	AND	0FH
	JR	NZ,MESET
	SET	7,(HL)
	;
MESET:	LD	A,(MMFLG)
	LD	B,A
	LD	A,(SETFLG)
	LD	HL,WRKBF+4
	RES	7,(HL)
	OR	B
	JR	Z,MOVEA
	SET	7,(HL)
	LD	HL,WRKBF
	RES	7,(HL)
	;
MOVEA:	LD	HL,WRKBF
	LD	DE,LEDS
	LD	B,11
MOVL:	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	MOVL
	;
	;	LD	A,(FUNFLG)
	;	OR	A
	;	JP	NZ,KYUNG
	LD	A,(ACTFLG)
	OR	A
	JP	Z,DISP
	;
	;----------------------------------------------
KEYROU: LD	HL,KEYDATA
	LD	A,(HL)		;KEY BOARD JUMP TABLE
	OR	A
	CP	0
	JP	Z,SETMEN
	CP	1
	JP	Z,ALLCLE
	CP	6
	JP	Z,TOMENU
	CP	7
	JP	Z,CREDIT
	CP	8
	JP	Z,TAMOV
	CP	9
	JP	Z,ONEDAY
	CP	0DH
	JP	Z,YUNGSU
	CP	0EH
	JP	Z,INPUT
	CP	0FH
	JP	Z,PAY
	CP	10H
	JP	Z,CLEAR
	CP	11H
	JP	Z,SUJUNG
	CP	15H
	JP	Z,FAPAY
	;-----------------------------------------------
	CP	16H
	JP	Z,M41
	CP	17H
	JP	Z,M42
	CP	18H
	JP	Z,M5
	CP	19H
	JP	Z,M4
	CP	1AH
	JP	Z,M3
	CP	1BH
	JP	Z,M2
	CP	1CH
	JP	Z,M1
	CP	1DH
	JP	Z,M36
	CP	1EH
	JP	Z,M6
	CP	1FH
	JP	Z,M7
	CP	20H
	JP	Z,M12
	CP	21H
	JP	Z,M11
	CP	22H
	JP	Z,M10
	CP	23H
	JP	Z,M9
	CP	24H
	JP	Z,M8
	CP	25H
	JP	Z,M37
	CP	26H
	JP	Z,M13
	CP	27H
	JP	Z,M14
	;------------------------NEXT MENU
	CP	28H
	JP	Z,M19
	CP	29H
	JP	Z,M18
	CP	2AH
	JP	Z,M17
	CP	2BH
	JP	Z,M16
	CP	2CH
	JP	Z,M15
	CP	2DH
	JP	Z,M38
	CP	2EH
	JP	Z,M20
	CP	2FH
	JP	Z,M21
	CP	30H
	JP	Z,M26
	CP	31H
	JP	Z,M25
	CP	32H
	JP	Z,M24
	CP	33H
	JP	Z,M23
	CP	34H
	JP	Z,M22
	CP	35H
	JP	Z,M39
	CP	36H
	JP	Z,M27
	CP	37H
	JP	Z,M28
	CP	38H
	JP	Z,M33
	CP	39H
	JP	Z,M32
	CP	3AH
	JP	Z,M31
	CP	3BH
	JP	Z,M30
	CP	3CH
	JP	Z,M29
	CP	3DH
	JP	Z,M40
	CP	3EH
	JP	Z,M34
	CP	3FH
	JP	Z,M35
	CP	0AH
	JP	Z,ARI8
	CP	0BH
	JP	Z,ARI5
	CP	0CH
	JP	Z,ARI2
	CP	2
	JP	Z,ARI7
	CP	3
	JP	Z,ARI4
	CP	4
	JP	Z,ARI1
	CP	5
	JP	Z,ARI0
	CP	12H
	JP	Z,ARI9
	CP	13H
	JP	Z,ARI6
	CP	14H
	JP	Z,ARI3
	;-------------------------------------------
	JP	DISP
	;-------------------------------------------
	;
	; TIMER SET (TIME COUNT = 0500H)
SETTIM: LD	A,0A0H
	LD	BC,RLDR0L
	OUT	(C),A
	LD	A,0
	LD	BC,RLDR0H
	OUT	(C),A
	LD	A,00010001B	; INTRUPT ON
	LD	BC,TCR
	OUT	(C),A
	NOP
	RET
	;
	; ###  ASCI0 INITIALIZE  ###
	;
INITAS0:LD	A,00100100B	;1S 8D NP 1S
	LD	BC,CNTLA0
	OUT	(C),A
	LD	A,00000001B	; 9600B
	LD	BC,CNTLB0
	OUT	(C),A
	RET
	;
	; ASCI0 ONLY TRANSFER
	;
SETAS0: LD	A,000000000B	 ;RIE ENABLE
	LD	BC,STAT0
	OUT	(C),A
	RET
	;
	; ####	ASCI1 INITIALIZE  ###
	;
INITAS1:LD	A,00100100B	;1S 8D NP 1S
	LD	BC,CNTLA1
	OUT	(C),A
	LD	A,00000001B	; 9600B
	LD	BC,CNTLB1
	OUT	(C),A
	RET
	;
	; ASCI1 RECEIVE INTERRUPT ON
	;
SETAS1: LD	A,00001000B	;RIE ENABLE 00001000B
	LD	BC,STAT1
	OUT	(C),A
	RET
	;
	ORG	400H
	; INTERUPT VECTOR  --------------------
	;
IVECTOR:DW	INT1
	DW	INT2
	DW	TIM0
	DW	TIM1
	DW	DMA0
	DW	DMA1
	DW	CSI
	DW	ASCI0
	DW	ASCI1
	NOP
	NOP
	;
	; SET INTERUPT VECTOR ADDRESS
	;
INITVEC:XOR	A
	LD	BC,ITC
	OUT	(C),A
	NOP
	LD	A,4
	LD	I,A
	LD	A,00H
	LD	BC,IL
	OUT	(C),A
	RET
	;
	; INTERRUPT SUBROUTINE
	;
INT1:	RETI
INT2:	RETI
TIM1:	RETI
DMA0:	RETI
DMA1:	RETI
CSI:	RETI
ASCI0:	RETI
ASCI1:	RETI
	;------------------------------------------------
CONVT:	LD	HL,WRKBF
	CALL	CONV
	CALL	CONV
	CALL	CONV
	CALL	CONV
	CALL	CONV
	CALL	CONV
	RET
	;
CONVTA: LD	B,7
CONVTB: LD	DE,WRKBF+7
CONVL:	LD	A,(DE)
	SUB	3FH
	RET	NZ
	LD	(DE),A
	DEC	DE
	DJNZ	CONVL
	RET
	;
CONV:	LD	A,(DE)
	PUSH	AF
	AND	0FH
	CALL	CONV1
	POP	AF
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	CALL	CONV1
	INC	DE
	RET
	;
CONV1:	LD	BC,TABLE
	ADD	A,C
	LD	C,A
	LD	A,(BC)
	LD	(HL),A
	INC	HL
	RET
	;
MOVXA:	LD	DE,WRKBF+6
MOVX1:	LD	B,4
MOVX:	LD	A,(HL)
	LD	(DE),A
	DEC	HL
	DEC	DE
	DJNZ	MOVX
	RET
	;
	;===============================
ARI0:	LD	A,0
	JP	TABON
ARI1:	LD	A,1
	JP	TABON
ARI2:	LD	A,2
	JP	TABON
ARI3:	LD	A,3
	JP	TABON
ARI4:	LD	A,4
	JP	TABON
ARI5:	LD	A,5
	JP	TABON
ARI6:	LD	A,6
	JP	TABON
ARI7:	LD	A,7
	JP	TABON
ARI8:	LD	A,8
	JP	TABON
ARI9:	LD	A,9
	JP	TABON
	;
YUNGSU: LD	A,(DATA+4)
	OR	A
	JP	Z,DISP
	LD	A,(PAYFLG)
	OR	A
	JP	Z,DISP
	CALL	PRINTY
	JP	DISP
	;------------------------------------------------
TABON:	LD	B,A
	LD	A,(GPASS)
	OR	A
	JP	NZ,GIVDISP
	LD	A,(DCFLG)
	OR	A
	JP	NZ,SETDISP
	LD	A,(PAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TPAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(CRFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(FAFLG)
	OR	A
	JP	NZ,DISP
	;
	LD	A,0FH
	LD	(TABPUN),A
	;
	LD	(BELLFLG),A
	;
	LD	A,(JUMPFLG)
	OR	A
	JP	NZ,DISP
	;
	LD	A,(MUXFLG)
	OR	A
	JR	NZ,MUXDISP
	LD	A,(SETFLG)
	OR	A
	JR	NZ,SETDISP
	LD	A,B
	LD	HL,DATA+4	;TABLE SERCH 1 TO 99
	RLD
	INC	HL
	RLD
	LD	A,(HL)
	AND	0FH
	JP	NZ,DISP
	;
	CALL	SETADR
KEYCEA: LD	A,(DATA+4)	;LAMP ON / OFF
	CPD
	JR	Z,SONIN
	CALL	UUT
	JR	NZ,KEYCEA
	JP	DISP
	;
GIVDISP:LD	A,0FH
	LD	(BELLFLG),A
	LD	A,B
	LD	HL,DATA
	RLD
	INC	HL
	RLD
	INC	HL
	RLD
	INC	HL
	RLD
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;
SETDISP:LD	HL,WRKBF+4
	RES	7,(HL)
	LD	A,B
	LD	HL,DATA
	RLD
	INC	HL
	RLD
	INC	HL
	RLD
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;-------------------------------------------
MUXDISP:LD	A,B
	LD	HL,DATA
	RLD
	JP	DISP
	;-------------------------------------------
SONIN:	LD	B,3
SONLIM: LD	A,(DE)
	OR	A
	JR	NZ,SONON
	INC	DE
	DJNZ	SONLIM
	XOR	A
	LD	(LAFLG),A
	JP	DISP
	;
SONON:	LD	A,0FH
	LD	(LAFLG),A
	JP	DISP
	;
MSERCH: LD	A,(PAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(SETFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TPAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(JUMPFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TABPUN)
	OR	A
	JP	Z,DISP
	LD	A,(CRFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(FAFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MUXFLG)
	OR	A
	JP	Z,INPASS
	CALL	MUXCES
	;
INPASS: LD	A,0FH
	LD	(MENPUN),A
	LD	(INFLG),A
	LD	(MUXFLG),A
	LD	(BELLFLG),A
	;
	LD	HL,DATA+5
	LD	A,(HL)
	AND	0FH
	OR	A
	JP	NZ,CLEAR
	XOR	A
	IN	A,(FUNKEY)
	BIT	6,A
	RET
	;----------------------------------------------
	;
M1:	CALL	MSERCH
	JP	Z,M43
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M85
	LD	HL,MENU1
	CALL	ADDT3
	LD	HL,WORK+4
	LD	BC,1
	JP	ADDT1
	;
M2:	CALL	MSERCH
	JP	Z,M44
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M86
	LD	HL,MENU2
	CALL	ADDT3
	LD	HL,WORK+6
	LD	BC,2
	JP	ADDT1
	;
M3:	CALL	MSERCH
	JP	Z,M45
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M87
	LD	HL,MENU3
	CALL	ADDT3
	LD	HL,WORK+8
	LD	BC,3
	JP	ADDT1
	;
M4:	CALL	MSERCH
	JP	Z,M46
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M88
	LD	HL,MENU4
	CALL	ADDT3
	LD	HL,WORK+10
	LD	BC,4
	JP	ADDT1
	;
M5:	CALL	MSERCH
	JP	Z,M47
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M89
	LD	HL,MENU5
	CALL	ADDT3
	LD	HL,WORK+12
	LD	BC,5
	JP	ADDT1
	;
M6:	CALL	MSERCH
	JP	Z,M48
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M90
	LD	HL,MENU6
	CALL	ADDT3
	LD	HL,WORK+14
	LD	BC,6
	JP	ADDT1
	;
M7:	CALL	MSERCH
	JP	Z,M49
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M91
	LD	HL,MENU7
	CALL	ADDT3
	LD	HL,WORK+16
	LD	BC,7
	JP	ADDT1
	;
M8:	CALL	MSERCH
	JP	Z,M50
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M92
	LD	HL,MENU8
	CALL	ADDT3
	LD	HL,WORK+18
	LD	BC,8
	JP	ADDT1
	;
M9:	CALL	MSERCH
	JP	Z,M51
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M93
	LD	HL,MENU9
	CALL	ADDT3
	LD	HL,WORK+20
	LD	BC,9
	JP	ADDT1
	;
M10:	CALL	MSERCH
	JP	Z,M52
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M94
	LD	HL,MENU10
	CALL	ADDT3
	LD	HL,WORK+22
	LD	BC,10H
	JP	ADDT1
	;
M11	CALL	MSERCH
	JP	Z,M53
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M95
	LD	HL,MENU11
	CALL	ADDT3
	LD	HL,WORK+24
	LD	BC,11H
	JP	ADDT1
	;
M12:	CALL	MSERCH
	JP	Z,M54
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M96
	LD	HL,MENU12
	CALL	ADDT3
	LD	HL,WORK+26
	LD	BC,12H
	JP	ADDT1
	;
M13:	CALL	MSERCH
	JP	Z,M55
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M97
	LD	HL,MENU13
	CALL	ADDT3
	LD	HL,WORK+28
	LD	BC,13H
	JP	ADDT1
	;
M14:	CALL	MSERCH
	JP	Z,M56
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M98
	LD	HL,MENU14
	CALL	ADDT3
	LD	HL,WORK+30
	LD	BC,14H
	JP	ADDT1
	;
M15:	CALL	MSERCH
	JP	Z,M57
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M99
	LD	HL,MENU15
	CALL	ADDT3
	LD	HL,WORK+32
	LD	BC,15H
	JP	ADDT1
	;
M16:	CALL	MSERCH
	JP	Z,M58
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M100
	LD	HL,MENU16
	CALL	ADDT3
	LD	HL,WORK+34
	LD	BC,16H
	JP	ADDT1
	;
M17:	CALL	MSERCH
	JP	Z,M59
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M101
	LD	HL,MENU17
	CALL	ADDT3
	LD	HL,WORK+36
	LD	BC,17H
	JP	ADDT1
	;
M18:	CALL	MSERCH
	JP	Z,M60
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M102
	LD	HL,MENU18
	CALL	ADDT3
	LD	HL,WORK+38
	LD	BC,18H
	JP	ADDT1
	;
M19:	CALL	MSERCH
	JP	Z,M61
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M103
	LD	HL,MENU19
	CALL	ADDT3
	LD	HL,WORK+40
	LD	BC,19H
	JP	ADDT1
	;
M20:	CALL	MSERCH
	JP	Z,M62
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M104
	LD	HL,MENU20
	CALL	ADDT3
	LD	HL,WORK+42
	LD	BC,20H
	JP	ADDT1
	;
M21	CALL	MSERCH
	JP	Z,M63
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M105
	LD	HL,MENU21
	CALL	ADDT3
	LD	HL,WORK+44
	LD	BC,21H
	JP	ADDT1
	;
M22:	CALL	MSERCH
	JP	Z,M64
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M106
	LD	HL,MENU22
	CALL	ADDT3
	LD	HL,WORK+46
	LD	BC,22H
	JP	ADDT1
	;
M23:	CALL	MSERCH
	JP	Z,M65
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M107
	LD	HL,MENU23
	CALL	ADDT3
	LD	HL,WORK+48
	LD	BC,23H
	JP	ADDT1
	;
M24:	CALL	MSERCH
	JP	Z,M66
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M108
	LD	HL,MENU24
	CALL	ADDT3
	LD	HL,WORK+50
	LD	BC,24H
	JP	ADDT1
	;
M25:	CALL	MSERCH
	JP	Z,M67
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M109
	LD	HL,MENU25
	CALL	ADDT3
	LD	HL,WORK+52
	LD	BC,25H
	JP	ADDT1
	;
M26:	CALL	MSERCH
	JP	Z,M68
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M110
	LD	HL,MENU26
	CALL	ADDT3
	LD	HL,WORK+54
	LD	BC,26H
	JP	ADDT1
	;
M27:	CALL	MSERCH
	JP	Z,M69
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M111
	LD	HL,MENU27
	CALL	ADDT3
	LD	HL,WORK+56
	LD	BC,27H
	JP	ADDT1
	;
M28:	CALL	MSERCH
	JP	Z,M70
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M112
	LD	HL,MENU28
	CALL	ADDT3
	LD	HL,WORK+58
	LD	BC,28H
	JP	ADDT1
	;
M29:	CALL	MSERCH
	JP	Z,M71
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M113
	LD	HL,MENU29
	CALL	ADDT3
	LD	HL,WORK+60
	LD	BC,29H
	JP	ADDT1
	;
M30:	CALL	MSERCH
	JP	Z,M72
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M114
	LD	HL,MENU30
	CALL	ADDT3
	LD	HL,WORK+62
	LD	BC,30H
	JP	ADDT1
	;
M31:	CALL	MSERCH
	JP	Z,M73
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M115
	LD	HL,MENU31
	CALL	ADDT3
	LD	HL,WORK+64
	LD	BC,31H
	JP	ADDT1
	;
M32:	CALL	MSERCH
	JP	Z,M74
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M116
	LD	HL,MENU32
	CALL	ADDT3
	LD	HL,WORK+66
	LD	BC,32H
	JP	ADDT1
	;
M33:	CALL	MSERCH
	JP	Z,M75
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M117
	LD	HL,MENU33
	CALL	ADDT3
	LD	HL,WORK+68
	LD	BC,33H
	JP	ADDT1
	;
M34:	CALL	MSERCH
	JP	Z,M76
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M118
	LD	HL,MENU34
	CALL	ADDT3
	LD	HL,WORK+70
	LD	BC,34H
	JP	ADDT1
	;
M35:	CALL	MSERCH
	JP	Z,M77
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M119
	LD	HL,MENU35
	CALL	ADDT3
	LD	HL,WORK+72
	LD	BC,35H
	JP	ADDT1
	;
M36:	CALL	MSERCH
	JP	Z,M78
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M120
	LD	HL,MENU36
	CALL	ADDT3
	LD	HL,WORK+74
	LD	BC,36H
	JP	ADDT1
	;
M37:	CALL	MSERCH
	JP	Z,M79
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M121
	LD	HL,MENU37
	CALL	ADDT3
	LD	HL,WORK+76
	LD	BC,37H
	JP	ADDT1
	;
M38:	CALL	MSERCH
	JP	Z,M80
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M122
	LD	HL,MENU38
	CALL	ADDT3
	LD	HL,WORK+78
	LD	BC,38H
	JP	ADDT1
	;
M39:	CALL	MSERCH
	JP	Z,M81
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M123
	LD	HL,MENU39
	CALL	ADDT3
	LD	HL,WORK+80
	LD	BC,39H
	JP	ADDT1
	;
M40:	CALL	MSERCH
	JP	Z,M82
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M124
	LD	HL,MENU40
	CALL	ADDT3
	LD	HL,WORK+82
	LD	BC,40H
	JP	ADDT1
	;
M41:	CALL	MSERCH
	JP	Z,M83
	IN	A,(GKEY)
	BIT	7,A
	JP	Z,M125
	LD	HL,MENU41
	CALL	ADDT3
	LD	HL,WORK+84
	LD	BC,41H
	JP	ADDT1
	;
M42:	CALL	MSERCH
	JP	Z,M84
	LD	HL,MENU42
	CALL	ADDT3
	LD	HL,WORK+86
	LD	BC,42H
	JP	ADDT1
	;-------------------------------------------
M43:	LD	HL,MENU43
	CALL	ADDT3
	LD	HL,WORK+88
	LD	BC,43H
	JP	ADDT1
	;
M44:	LD	HL,MENU44
	CALL	ADDT3
	LD	HL,WORK+90
	LD	BC,44H
	JP	ADDT1
	;
M45:	LD	HL,MENU45
	CALL	ADDT3
	LD	HL,WORK+92
	LD	BC,45H
	JP	ADDT1
	;
M46:	LD	HL,MENU46
	CALL	ADDT3
	LD	HL,WORK+94
	LD	BC,46H
	JP	ADDT1
	;
M47:	LD	HL,MENU47
	CALL	ADDT3
	LD	HL,WORK+96
	LD	BC,47H
	JP	ADDT1
	;
M48:	LD	HL,MENU48
	CALL	ADDT3
	LD	HL,WORK+98
	LD	BC,48H
	JP	ADDT1
	;
M49:	LD	HL,MENU49
	CALL	ADDT3
	LD	HL,WORK+100
	LD	BC,49H
	JP	ADDT1
	;
M50:	LD	HL,MENU50
	CALL	ADDT3
	LD	HL,WORK+102
	LD	BC,50H
	JP	ADDT1
	;
M51:	LD	HL,MENU51
	CALL	ADDT3
	LD	HL,WORK+104
	LD	BC,51H
	JP	ADDT1
	;
M52:	LD	HL,MENU52
	CALL	ADDT3
	LD	HL,WORK+106
	LD	BC,52H
	JP	ADDT1
	;
M53:	LD	HL,MENU53
	CALL	ADDT3
	LD	HL,WORK+108
	LD	BC,53H
	JP	ADDT1
	;
M54:	LD	HL,MENU54
	CALL	ADDT3
	LD	HL,WORK+110
	LD	BC,54H
	JP	ADDT1
	;
M55:	LD	HL,MENU55
	CALL	ADDT3
	LD	HL,WORK+112
	LD	BC,55H
	JP	ADDT1
	;
M56:	LD	HL,MENU56
	CALL	ADDT3
	LD	HL,WORK+114
	LD	BC,56H
	JP	ADDT1
	;
M57:	LD	HL,MENU57
	CALL	ADDT3
	LD	HL,WORK+116
	LD	BC,57H
	JP	ADDT1
	;
M58:	LD	HL,MENU58
	CALL	ADDT3
	LD	HL,WORK+118
	LD	BC,58H
	JP	ADDT1
	;
M59:	LD	HL,MENU59
	CALL	ADDT3
	LD	HL,WORK+120
	LD	BC,59H
	JP	ADDT1
	;
M60:	LD	HL,MENU60
	CALL	ADDT3
	LD	HL,WORK+122
	LD	BC,60H
	JP	ADDT1
	;
M61:	LD	HL,MENU61
	CALL	ADDT3
	LD	HL,WORK+124
	LD	BC,61H
	JP	ADDT1
	;
M62:	LD	HL,MENU62
	CALL	ADDT3
	LD	HL,WORK+126
	LD	BC,62H
	JP	ADDT1
	;
M63:	LD	HL,MENU63
	CALL	ADDT3
	LD	HL,WORK+128
	LD	BC,63H
	JP	ADDT1
	;
M64:	LD	HL,MENU64
	CALL	ADDT3
	LD	HL,WORK+130
	LD	BC,64H
	JP	ADDT1
	;
M65:	LD	HL,MENU65
	CALL	ADDT3
	LD	HL,WORK+132
	LD	BC,65H
	JP	ADDT1
	;
M66:	LD	HL,MENU66
	CALL	ADDT3
	LD	HL,WORK+134
	LD	BC,66H
	JP	ADDT1
	;
M67:	LD	HL,MENU67
	CALL	ADDT3
	LD	HL,WORK+136
	LD	BC,67H
	JP	ADDT1
	;
M68:	LD	HL,MENU68
	CALL	ADDT3
	LD	HL,WORK+138
	LD	BC,68H
	JP	ADDT1
	;
M69:	LD	HL,MENU69
	CALL	ADDT3
	LD	HL,WORK+140
	LD	BC,69H
	JP	ADDT1
	;
M70:	LD	HL,MENU70
	CALL	ADDT3
	LD	HL,WORK+142
	LD	BC,70H
	JP	ADDT1
	;
M71:	LD	HL,MENU71
	CALL	ADDT3
	LD	HL,WORK+144
	LD	BC,71H
	JP	ADDT1
	;
M72:	LD	HL,MENU72
	CALL	ADDT3
	LD	HL,WORK+146
	LD	BC,72H
	JP	ADDT1
	;
M73:	LD	HL,MENU73
	CALL	ADDT3
	LD	HL,WORK+148
	LD	BC,73H
	JP	ADDT1
	;
M74:	LD	HL,MENU74
	CALL	ADDT3
	LD	HL,WORK+150
	LD	BC,74H
	JP	ADDT1
	;
M75:	LD	HL,MENU75
	CALL	ADDT3
	LD	HL,WORK+152
	LD	BC,75H
	JP	ADDT1
	;
M76:	LD	HL,MENU76
	CALL	ADDT3
	LD	HL,WORK+154
	LD	BC,76H
	JP	ADDT1
	;
M77:	LD	HL,MENU77
	CALL	ADDT3
	LD	HL,WORK+156
	LD	BC,77H
	JP	ADDT1
	;
M78:	LD	HL,MENU78
	CALL	ADDT3
	LD	HL,WORK+158
	LD	BC,78H
	JP	ADDT1
	;
M79:	LD	HL,MENU79
	CALL	ADDT3
	LD	HL,WORK+160
	LD	BC,79H
	JP	ADDT1
	;
M80:	LD	HL,MENU80
	CALL	ADDT3
	LD	HL,WORK+162
	LD	BC,80H
	JP	ADDT1
	;
M81:	LD	HL,MENU81
	CALL	ADDT3
	LD	HL,WORK+164
	LD	BC,81H
	JP	ADDT1
	;
M82:	LD	HL,MENU82
	CALL	ADDT3
	LD	HL,WORK+166
	LD	BC,82H
	JP	ADDT1
	;
M83:	LD	HL,MENU83
	CALL	ADDT3
	LD	HL,WORK+168
	LD	BC,83H
	JP	ADDT1
	;
M84:	LD	HL,MENU84
	CALL	ADDT3
	LD	HL,WORK+170
	LD	BC,84H
	JP	ADDT1
	;
M85:	LD	HL,MENU85
	CALL	ADDT3
	LD	HL,WORK+172
	LD	BC,85H
	JP	ADDT1
	;
M86:	LD	HL,MENU86
	CALL	ADDT3
	LD	HL,WORK+174
	LD	BC,86H
	JP	ADDT1
	;
M87:	LD	HL,MENU87
	CALL	ADDT3
	LD	HL,WORK+176
	LD	BC,87H
	JP	ADDT1
	;
M88:	LD	HL,MENU88
	CALL	ADDT3
	LD	HL,WORK+178
	LD	BC,88H
	JP	ADDT1
	;
M89:	LD	HL,MENU89
	CALL	ADDT3
	LD	HL,WORK+180
	LD	BC,89H
	JP	ADDT1
	;
M90:	LD	HL,MENU90
	CALL	ADDT3
	LD	HL,WORK+182
	LD	BC,90H
	JP	ADDT1
	;
M91:	LD	HL,MENU91
	CALL	ADDT3
	LD	HL,WORK+184
	LD	BC,91H
	JP	ADDT1
	;
M92:	LD	HL,MENU92
	CALL	ADDT3
	LD	HL,WORK+186
	LD	BC,92H
	JP	ADDT1
	;
M93:	LD	HL,MENU93
	CALL	ADDT3
	LD	HL,WORK+188
	LD	BC,93H
	JP	ADDT1
	;
M94:	LD	HL,MENU94
	CALL	ADDT3
	LD	HL,WORK+190
	LD	BC,94H
	JP	ADDT1
	;
M95:	LD	HL,MENU95
	CALL	ADDT3
	LD	HL,WORK+192
	LD	BC,95H
	JP	ADDT1
	;
M96:	LD	HL,MENU96
	CALL	ADDT3
	LD	HL,WORK+194
	LD	BC,96H
	JP	ADDT1
	;
M97:	LD	HL,MENU97
	CALL	ADDT3
	LD	HL,WORK+196
	LD	BC,97H
	JP	ADDT1
	;
M98:	LD	HL,MENU98
	CALL	ADDT3
	LD	HL,WORK+198
	LD	BC,98H
	JP	ADDT1
	;
M99:	LD	HL,MENU99
	CALL	ADDT3
	LD	HL,WORK+200
	LD	BC,99H
	JP	ADDT1
	;
M100:	LD	HL,MENU100
	CALL	ADDT3
	LD	HL,WORK+202
	LD	BC,100H
	JP	ADDT1
	;
M101:	LD	HL,MENU101
	CALL	ADDT3
	LD	HL,WORK+204
	LD	BC,101H
	JP	ADDT1
	;
M102:	LD	HL,MENU102
	CALL	ADDT3
	LD	HL,WORK+206
	LD	BC,102H
	JP	ADDT1
	;
M103:	LD	HL,MENU103
	CALL	ADDT3
	LD	HL,WORK+208
	LD	BC,103H
	JP	ADDT1
	;
M104:	LD	HL,MENU104
	CALL	ADDT3
	LD	HL,WORK+210
	LD	BC,104H
	JP	ADDT1
	;
M105:	LD	HL,MENU105
	CALL	ADDT3
	LD	HL,WORK+212
	LD	BC,105H
	JP	ADDT1
	;
M106:	LD	HL,MENU106
	CALL	ADDT3
	LD	HL,WORK+214
	LD	BC,106H
	JP	ADDT1
	;
M107:	LD	HL,MENU107
	CALL	ADDT3
	LD	HL,WORK+216
	LD	BC,107H
	JP	ADDT1
	;
M108:	LD	HL,MENU108
	CALL	ADDT3
	LD	HL,WORK+218
	LD	BC,108H
	JP	ADDT1
	;
M109:	LD	HL,MENU109
	CALL	ADDT3
	LD	HL,WORK+220
	LD	BC,109H
	JP	ADDT1
	;
M110:	LD	HL,MENU110
	CALL	ADDT3
	LD	HL,WORK+222
	LD	BC,110H
	JP	ADDT1
	;
M111:	LD	HL,MENU111
	CALL	ADDT3
	LD	HL,WORK+224
	LD	BC,111H
	JP	ADDT1
	;
M112:	LD	HL,MENU112
	CALL	ADDT3
	LD	HL,WORK+226
	LD	BC,112H
	JP	ADDT1
	;
M113:	LD	HL,MENU113
	CALL	ADDT3
	LD	HL,WORK+228
	LD	BC,113H
	JP	ADDT1
	;
M114:	LD	HL,MENU114
	CALL	ADDT3
	LD	HL,WORK+230
	LD	BC,114H
	JP	ADDT1
	;
M115:	LD	HL,MENU115
	CALL	ADDT3
	LD	HL,WORK+232
	LD	BC,115H
	JP	ADDT1
	;
M116:	LD	HL,MENU116
	CALL	ADDT3
	LD	HL,WORK+234
	LD	BC,116H
	JP	ADDT1
	;
M117:	LD	HL,MENU117
	CALL	ADDT3
	LD	HL,WORK+236
	LD	BC,117H
	JP	ADDT1
	;
M118:	LD	HL,MENU118
	CALL	ADDT3
	LD	HL,WORK+238
	LD	BC,118H
	JP	ADDT1
	;
M119:	LD	HL,MENU119
	CALL	ADDT3
	LD	HL,WORK+240
	LD	BC,119H
	JP	ADDT1
	;
M120:	LD	HL,MENU120
	CALL	ADDT3
	LD	HL,WORK+242
	LD	BC,120H
	JP	ADDT1
	;
M121:	LD	HL,MENU121
	CALL	ADDT3
	LD	HL,WORK+244
	LD	BC,121H
	JP	ADDT1
	;
M122:	LD	HL,MENU122
	CALL	ADDT3
	LD	HL,WORK+246
	LD	BC,122H
	JP	ADDT1
	;
M123:	LD	HL,MENU123
	CALL	ADDT3
	LD	HL,WORK+248
	LD	BC,123H
	JP	ADDT1
	;
M124:	LD	HL,MENU124
	CALL	ADDT3
	LD	HL,WORK+250
	LD	BC,124H
	JP	ADDT1
	;
M125:	LD	HL,MENU125
	CALL	ADDT3
	LD	HL,WORK+252
	LD	BC,125H
	JP	ADDT1
	;
	;----------------------------------------------
ADDT1:	LD	A,1
	LD	(HL),A
	;
	LD	A,B
	LD	(DATA+3),A
	LD	A,C
	LD	(DATA+2),A
	LD	A,0
	LD	(DATA),A
	LD	(DATA+1),A
	;
	LD	A,0FH
	LD	(INFLG),A
	LD	(MUXFLG),A
	JP	DISP
	;-----------------------------------------------
CLEAR:	LD	A,0FH
	LD	(BELLFLG),A
	LD	A,(JJFLG)
	OR	A
	JP	NZ,DISP
	;
	LD	A,(CLEFLG)
	OR	A
	JR	Z,CLEON
	LD	A,0
	LD	(DATA),A
	LD	(DATA+1),A
	LD	(DATA+2),A
	LD	(CLEFLG),A
	LD	(MUXBF),A
	LD	(MUXBF+1),A
	LD	(MUXBF+2),A
	LD	(MUXBF+3),A
	JP	DISP
	;
CLEON:	LD	A,0
	LD	(DATA),A
	LD	(DATA+1),A
	LD	(DATA+2),A
	LD	(DATA+3),A
	LD	(DATA+4),A
	LD	(DATA+5),A
	LD	(AREA),A
	LD	(AREA+1),A
	LD	(AREA+2),A
	LD	(AREA+3),A
	;
	LD	HL,WORK 	;WORK BUFFER CLEAR
	LD	BC,0254
CLOOP1: XOR	A
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,CLOOP1
	;
	LD	HL,TEMBF	;WORK BUFFER CLEAR
	LD	BC,0254
CLOOP2: XOR	A
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,CLOOP2
	;
	LD	HL,MPB
	LD	BC,0750 	 ;504 * 2 MPB MPB1
CLOOP3: XOR	A
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,CLOOP3
	;
	LD	HL,TRANBF
	LD	BC,50
CLOOP4: XOR	A
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,CLOOP4
	;
	LD	A,1		;CPD BUFFER NORMAL 1 SET
	LD	(CPDBF),A
	;
	LD	A,0		;FLAG RESET
	LD	(JJFLG),A
	LD	(CIRFLG),A
	LD	(HOUFLG),A
	LD	(MONFLG),A
	LD	(PAYFLG),A
	LD	(TMOVFLG),A
	LD	(MENUFLG),A
	LD	(MUXFLG),A
	LD	(TMEFLG),A
	LD	(SETFLG),A
	LD	(LAFLG),A
	LD	(TPAYFLG),A
	LD	(MENPUN),A
	LD	(DISPFLG),A
	LD	(TABPUN),A
	LD	(BLANK),A
	LD	(JUMPFLG),A
	LD	(CRFLG),A
	LD	(FAFLG),A
	LD	(INFLG),A
	LD	(CLEMUX),A
	LD	(MMFLG),A
	LD	(GPASS),A
	LD	(GIVEFLG),A
	LD	(GIVACT),A
	LD	(GIVACT1),A
	LD	(GIVMDA),A
	LD	(GIVMDA+1),A
	LD	(GIVMDA+2),A
	LD	(GIVMDA+3),A
	LD	(PRONFLG),A
	LD	(BUAFLG),A
	LD	(BUBFLG),A
	LD	(BUCFLG),A
	LD	(DCFLG),A
	;
	LD	(PRDC),A
	LD	(PRDC+1),A
	LD	(PRDC+2),A
	LD	(PRDC+3),A
	JP	DISP
	;------------------------
MUXCES: LD	A,(DATA)
	OR	A
	JP	Z,DISP
	LD	A,0FH
	LD	(DISPFLG),A
	LD	(CLEMUX),A
	LD	B,125
	LD	DE,DATA
	LD	HL,WORK+4
MUMENU: LD	A,(HL)
	OR	A
	JR	NZ,MUMENU1
	INC	HL
	INC	HL
	DJNZ	MUMENU
	RET
	;
MUMENU1:LD	A,(DE)
	LD	(HL),A
	INC	DE
	INC	HL
	LD	A,(DE)
	LD	(HL),A
	;
	LD	BC,DATA
	LD	A,(BC)
	OR	A
	JR	NZ,MUX1
	INC	BC
	LD	A,(BC)
	OR	A
	JR	NZ,MUX1
	RET
	;
MUX1:	AND	A
	LD	BC,DATA
	SBC	A,1
	DAA
	LD	(BC),A
	INC	BC
	LD	A,(BC)
	SBC	A,0
	DAA
	LD	(BC),A
	;
	OR	A
	JR	NZ,MUX2
	DEC	BC
	LD	A,(BC)
	OR	A
	JR	NZ,MUX2
	LD	A,1
	LD	(BC),A
	JR	MUXLP2
	;
MUX2:	LD	HL,WORK
	LD	DE,MUXBF
	LD	BC,4
	LDIR
	;
MUXLP1: LD	HL,WORK
	LD	DE,MUXBF
	XOR	A
	EX	DE,HL
	CALL	ADD4DG
	EX	DE,HL
	;
MUXLP2: AND	A
	LD	BC,DATA
	LD	A,(BC)
	SBC	A,1
	DAA
	LD	(BC),A
	INC	BC
	LD	A,(BC)
	SBC	A,0
	DAA
	LD	(BC),A
	;
	OR	A
	JR	NZ,MUXLP1
	DEC	BC
	LD	A,(BC)
	OR	A
	JR	NZ,MUXLP1
	LD	A,0
	LD	(DISPFLG),A
	CALL	MOVWORK
	RET
	;-----------------------------------------------
INPUT:	LD	A,(DATA+5)	;TABLE OF DATA INSERT
	AND	0FH
	JP	NZ,CLEAR
	LD	A,(JJFLG)
	OR	A
	JP	NZ,JPRINT
	LD	A,(DATA)
	OR	A
	JP	Z,CLEAR
	LD	A,(PAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TPAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(SETFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(CRFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(FAFLG)
	OR	A
	JP	NZ,DISP
	;----------------------------------------------
	CALL	MUXCES
	;
	CALL	JUNADD		;JUNPYO,CHNO = ASC II CONVERT
	CALL	DATAIN		;TABLE MONITOR DATA IN
	;
	IN	A,(FUNKEY)
	BIT	6,A
	JR	Z,NEXTAT
	;
	CALL	PRINTJ		;JUNPYO PRINT
	;
NEXTAT: CALL	SETADR
COMPAR: LD	A,(DATA+4)	;TABLE NUMBER COMPARE
	CPD
	JR	Z,NT
	CALL	UUT
	JR	NZ,COMPAR
	JP	CLEAR
	;
UUT:	INC	HL		;CPDBF =/= TABLE NUMBER
	LD	A,1		;ROUTINE INC. 23
	ADD	A,(HL)
	DAA
	LD	(HL),A
	AND	A
	LD	A,254		;WORK BUFFER LENGTH 84*2+4
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	LD	A,C
	OR	B
	RET
	;
JUNADD: LD	A,1		;JUNPYO PRINTING
	LD	HL,JUNNO+1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	DEC	HL
	LD	A,0
	ADC	A,(HL)
	DAA
	LD	(HL),A
	;
	LD	HL,PRJUN	;PRJUN ALL 20H LOAD
	LD	B,8		;PRCHNO ALL 20H LOAD
PRJCLE: LD	(HL),20H
	INC	HL
	DJNZ	PRJCLE
	;
	LD	HL,PRJUN
	LD	BC,JUNNO-1
	CALL	ASCVT4
	;
	LD	HL,EXDATA
	LD	A,(DATA+5)
	LD	(HL),A
	INC	HL
	LD	A,(DATA+4)
	LD	(HL),A
	LD	HL,PRCHNO
	LD	BC,EXDATA-1
	CALL	ASCVT4
	RET
	;
	;------------------------------------------
NT:	LD	HL,TEMBF
	;
	CALL	ADD4DG		;(HL)+(DE)=(DE) X 4
	;
	INC	DE
	INC	HL
	LD	B,125
MOVLOP: CALL	ADD2DG		;(HL)+(DE)=(DE) X 2
	INC	DE
	INC	HL
	DJNZ	MOVLOP
	JP	CLEAR
	;--------------------
MOVWORK:LD	DE,TEMBF
	LD	HL,WORK
	CALL	ADD4DG		;(HL)+(DE)=(DE) X 4
	INC	DE
	INC	HL
	LD	B,125
MOVW:	CALL	ADD2DG
	INC	DE
	INC	HL
	DJNZ	MOVW
	;
	LD	BC,254
	LD	DE,WORK
MOLW1:	LD	A,0
	LD	(DE),A
	INC	DE
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,MOLW1
	RET
	;------------------------------------------------
SETADR: LD	DE,TAB1
	LD	BC,63H
	LD	HL,CPDBF
	RET
	;
ADD4DG: XOR	A
	LD	A,(DE)			;(HL)+(DE)=(DE) X 4 DIGIT
	ADD	A,(HL)
	DAA
	LD	(DE),A
	INC	DE
	INC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(DE),A
	INC	DE
	INC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(DE),A
	INC	DE
	INC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(DE),A
	RET
	;
ADD2DG: XOR	A
	LD	A,(DE)
	ADD	A,(HL)
	DAA
	LD	(DE),A
	INC	DE
	INC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(DE),A
	RET
	;
	;------------------------------------------
JPRINT: CALL	JUNADD
	LD	A,0
	LD	(JJFLG),A
	;
	CALL	SETADR
JCOM:	LD	A,(DATA+4)	;TABLE NUMBER COMPARE
	CPD
	JR	Z,JNT
	CALL	UUT
	JR	NZ,JCOM
	JP	CLEAR
	;
JNT:	AND	A
	LD	BC,254
	LD	HL,TEMBF
JMOV:	LD	A,(DE)
	LD	(HL),A
	INC	DE
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,JMOV
	;
	CALL	JJMENU
	IN	A,(FUNKEY)
	BIT	6,A
	JP	Z,CLEAR
	;
	CALL	JJPRINT
	JP	CLEAR
	;
SUJUNG: LD	A,(PAYFLG)
	OR	A
	JP	Z,DISP
	;
	IN	A,(FUNKEY)
	BIT	6,A
	JP	Z,DCOUNT
	;
	LD	A,(MENUFLG)
	OR	A
	JP	Z,DISP
	;
	LD	A,0FH
	LD	(JJFLG),A
	;
	LD	HL,CPDBF
	LD	DE,TAB1+4
	LD	BC,63H
	;
CPSU1:	LD	A,(DATA+4)
	CPD
	JR	Z,SU1
	CALL	UUT
	JR	NZ,CPSU1
	JP	CLEAR
	;
SU1:	LD	A,1
	LD	(CPDBF),A
	;
	PUSH	IY
	LD	BC,126
	LD	IY,MENU1
	LD	HL,CPDBF1
	LD	(HL),1
	INC	HL
	LD	(HL),0
	;
CPSU2:	LD	HL,CPDBF1
	LD	A,(DATA+2)
	CP	(HL)
	JR	NZ,NOTEQ
	INC	HL
	LD	A,(DATA+3)
	CP	(HL)
	JR	Z,SU2
	;
	DEC	HL
NOTEQ:	INC	DE
	INC	DE
	INC	IY
	INC	IY
	INC	IY
	LD	A,1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	INC	HL
	LD	A,0
	ADC	A,(HL)
	DAA
	LD	(HL),A
	;
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,CPSU2
	JP	CLEAR
	;
SU2:	XOR	A
	LD	A,(DE)
	LD	B,A
	INC	DE
	LD	A,(DE)
	OR	B
	JP	Z,DISP
	DEC	DE
	LD	A,(DE)
	SUB	1
	DAA
	LD	(DE),A
	LD	(DATA),A
	INC	DE
	LD	A,(DE)
	SBC	0
	DAA
	LD	(DE),A
	LD	(DATA+1),A
	;
	LD	A,1
	LD	(CPDBF),A
	;
	LD	A,1
	LD	(CPDBF),A
	LD	HL,CPDBF
	LD	DE,TAB1
	LD	BC,63H
	;
CPSU3:	LD	A,(DATA+4)
	CPD
	JR	Z,SU3
	CALL	UUT
	JR	NZ,CPSU3
	JP	CLEAR
	;
SU3:	XOR	A
	LD	A,(DE)
	SUB	(IY+0)
	DAA
	LD	(DE),A
	INC	DE
	LD	A,(DE)
	SBC	A,(IY+1)
	DAA
	LD	(DE),A
	INC	DE
	LD	A,(DE)
	SBC	A,(IY+2)
	DAA
	LD	(DE),A
	INC	DE
	LD	A,(DE)
	SBC	0
	DAA
	LD	(DE),A
	LD	A,1
	LD	(CPDBF),A
	;
	POP	IY
	;
	LD	A,(DE)
	LD	B,A
	DEC	DE
	LD	A,(DE)
	OR	B
	JR	NZ,CALPAS
	DEC	DE
	LD	A,(DE)
	LD	B,A
	DEC	DE
	LD	A,(DE)
	OR	B
	CALL	Z,DATOUT
	;
CALPAS: LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;------------------------------------------------
DCOUNT: LD	A,(DATA+4)
	OR	A
	JP	Z,DISP
	LD	A,(DCFLG)
	OR	A
	JR	NZ,DCPASS
	;
	LD	A,0FH
	LD	(DCFLG),A
	LD	HL,PRTEM
	LD	DE,DATA
	LD	B,4
MODCL:	LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	MODCL
	LD	A,0
	LD	(DATA),A
	LD	(DATA+1),A
	LD	(DATA+2),A
	LD	(DATA+3),A
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;
DCPASS: LD	HL,PRDC
	LD	DE,DATA
	LD	B,4
MODDL:	LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	MODDL
	;
	LD	HL,PRDC
	XOR	A
	LD	DE,PRTEM
	LD	A,(DE)
	SUB	(HL)
	DAA
	LD	(PRAMT),A
	INC	HL
	INC	DE
	LD	A,(DE)
	SBC	A,(HL)
	DAA
	LD	(PRAMT+1),A
	INC	HL
	INC	DE
	LD	A,(DE)
	SBC	A,(HL)
	DAA
	LD	(PRAMT+2),A
	INC	HL
	INC	DE
	LD	A,(DE)
	SBC	0
	DAA
	LD	(PRAMT+3),A
	;
	LD	HL,DATA
	LD	DE,PRAMT
	LD	B,4
MODEL:	LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	MODEL
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;-------------------------
	;
JJMENU: LD	HL,JJDATA
	LD	BC,1600
	;
JJMLP1: LD	A,(HL)
	INC	HL
	OR	(HL)
	JR	Z,JJMLP2
	XOR	A
	DEC	HL
	LD	A,8		;
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,JJMLP1
	RET
	;
JJMLP2: XOR	A
	DEC	HL
	LD	IX,WORK+4
	LD	IY,TEMBF+4
	LD	BC,1
	;
JJMCHK: LD	A,(IX)
	LD	D,A
	INC	IX
	LD	A,(IX)
	OR	D
	JR	Z,JJMPAS1
	;
	DEC	IX
	LD	A,(IX)
	CP	(IY)
	JR	NZ,JPASS1
	;
	INC	IX
	INC	IY
	LD	A,(IX)
	CP	(IY)
	JR	Z,JJMPAS2
	;
	DEC	IX
	DEC	IY
	;
JPASS1: LD	A,B		;MENU NO. HIGH
	LD	(HL),A
	INC	HL
	LD	A,C		;MENU NO. LOW
	LD	(HL),A
	INC	HL
	;
	INC	IX
	LD	A,(IX)
	LD	(HL),A
	DEC	IX
	INC	HL
	LD	A,(IX)
	LD	(HL),A
	INC	IX
	INC	IX
	INC	HL
	;
	INC	IY
	LD	A,(IY)
	LD	(HL),A
	DEC	IY
	INC	HL
	LD	A,(IY)
	LD	(HL),A
	INC	IY
	INC	IY
	INC	HL
	;
	LD	A,(DTIME+1)
	LD	(HL),A
	INC	HL
	LD	A,(DTIME)
	LD	(HL),A
	INC	HL
	JR	JJMPAS3
	;
JJMPAS1:INC	IY
	;
JJMPAS2:INC	IX
	INC	IY
JJMPAS3:XOR	A
	LD	A,1
	ADD	A,C
	DAA
	LD	C,A
	LD	A,0
	ADC	A,B
	DAA
	LD	B,A
	;
	CP	1
	JP	NZ,JJMCHK
	LD	A,C
	CP	26H
	JP	NZ,JJMCHK
	;
	RET
	;------------------------------------------------
TOMENU: LD	A,(MENPUN)
	OR	A
	JP	NZ,DISP
	LD	A,(GIVEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,TAMENU
	LD	A,(SETFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(CRFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(FAFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,SETUP
	;
	LD	A,(DATA+4)	;TABLE PAY / TOTAL INCOME
	OR	A
	JP	Z,CLEAR 	;TOTAL MENU DIS.
	LD	HL,DATA
	LD	A,(HL)
	INC	HL
	OR	(HL)
	JP	NZ,TAMENU
	INC	HL
	OR	(HL)
	JP	NZ,TAMENU
	INC	HL
	OR	(HL)
	JP	NZ,TAMENU	;TABLE MENU DISPLAY
	;
TOPAY:	LD	A,0FH		;TABLE PAY
	LD	(PAYFLG),A
	;
	CALL	SETADR
PAYLOP: LD	A,(DATA+4)
	CPD
	JR	Z,DISPAY
	CALL	UUT
	JR	NZ,PAYLOP
	JP	CLEAR
	;
DISPAY: LD	A,(DE)
	LD	(DATA),A
	INC	DE
	LD	A,(DE)
	LD	(DATA+1),A
	INC	DE
	LD	A,(DE)
	LD	(DATA+2),A
	INC	DE
	LD	A,(DE)
	LD	(DATA+3),A
	;----------------------------------------------
	DEC	DE
	DEC	DE
	DEC	DE
	;
	LD	A,(CIRFLG)
	OR	A
	JP	NZ,DISP 	       ;1 ROTATE NOT MOV WORK
	;
	LD	HL,WORK
	LD	BC,0254
PLOOP1: LD	A,(DE)
	LD	(HL),A
	INC	DE
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,PLOOP1		;PRINTER BUFFER
	;----------------------------------------------
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;
SETUP:	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TPAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,0FH
	LD	(TMEFLG),A
	;
	LD	DE,TOTAL+4
	LD	BC,126
	;
TOMAOP: LD	HL,DATA+4
	XOR	A
	LD	A,1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	LD	A,0
	INC	HL
	ADC	A,(HL)
	DAA
	LD	(HL),A
	CP	1
	JR	NZ,TOMM
	DEC	HL
	LD	A,(HL)
	CP	27
	JP	Z,CLEAR
	;
TOMM:	LD	HL,CPDBF1
	LD	(HL),0
	INC	HL
	LD	(HL),1
	;
	LD	BC,126
TOMLOP: LD	HL,CPDBF1
	LD	A,(DATA+4)
	CP	(HL)
	JR	NZ,TOM1
	INC	HL
	LD	A,(DATA+5)
	CP	(HL)
	JP	Z,TOMON

TOM1:	LD	HL,CPDBF1
	INC	DE
	INC	DE
	XOR	A
	LD	A,1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	INC	HL
	LD	A,0
	ADC	A,(HL)
	DAA
	LD	(HL),A
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,TOMLOP
	JP	CLEAR
	;
TOMON:	LD	A,(DE)
	OR	A
	JR	NZ,TODISP
	INC	DE
	LD	A,(DE)
	OR	A
	DEC	DE
	JR	NZ,TODISP
	INC	DE
	INC	DE
	INC	HL
	XOR	A
	LD	A,1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	INC	HL
	LD	A,0
	ADC	A,(HL)
	DAA
	LD	(HL),A
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,TOMAOP
	JP	CLEAR
	;
TODISP: LD	A,(DE)
	LD	(DATA),A
	INC	DE
	LD	A,(DE)
	LD	(DATA+1),A
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;
TAMENU: LD	A,(PAYFLG)
	OR	A
	JP	Z,DISP
	LD	A,(MENUFLG)
	OR	A
	JR	NZ,LDFLG
	XOR	A
	LD	(DATA),A
	LD	(DATA+1),A
	LD	(DATA+2),A
	LD	(DATA+3),A
	;
LDFLG:	LD	A,0FH
	LD	(MENUFLG),A
	LD	A,(DATA+4)
	OR	A
	JP	Z,BELOD
	;
	LD	HL,CPDBF
	LD	DE,TAB1+4
	LD	BC,63H
	;
MP:	LD	A,(DATA+4)
	CPD
	JR	Z,VMM
	CALL	UUT
	JR	NZ,MP
	JP	CLEAR
	;
VMM:	XOR	A
	LD	A,(DATA+2)
	ADD	A,1
	DAA
	LD	(DATA+2),A
	LD	A,(DATA+3)
	ADC	A,0
	DAA
	LD	(DATA+3),A
	;
	LD	IX,CPDBF1
	LD	(IX+0),1
	LD	(IX+1),0
	LD	BC,125
	;
VMMB:	LD	A,(DATA+2)
	CP	(IX+0)
	JR	NZ,VMMB1
	LD	A,(DATA+3)
	CP	(IX+1)
	JP	Z,DATSER
	;
VMMB1:	INC	DE
	INC	DE
	;
	XOR	A
	LD	A,1
	ADD	A,(IX+0)
	DAA
	LD	(IX+0),A
	LD	A,0
	ADC	A,(IX+1)
	DAA
	LD	(IX+1),A
	;
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,VMMB
	JP	CALPAY
	;
DATSER: LD	A,(DE)
	OR	A
	JP	NZ,DADISP1
	INC	DE
	LD	A,(DE)
	OR	A
	JP	NZ,DADISP2
	INC	DE
	;
	XOR	A
	LD	A,1
	ADD	A,(IX+0)
	DAA
	LD	(IX+0),A
	LD	A,0
	ADC	A,(IX+1)
	DAA
	LD	(IX+1),A
	;
	XOR	A
	LD	A,(DATA+2)
	ADD	A,1
	DAA
	LD	(DATA+2),A
	LD	A,(DATA+3)
	ADC	A,0
	DAA
	LD	(DATA+3),A
	DEC	BC
	;
	LD	A,C
	OR	B
	JP	NZ,VMMB
	;
CALPAY: LD	A,0
	LD	(MENUFLG),A
	LD	(DATA),A
	LD	(DATA+1),A
	LD	(DATA+2),A
	LD	(DATA+3),A
	LD	(CPDBF+1),A
	LD	A,1
	LD	(CPDBF),A
	LD	(CPDBF1),A
	LD	A,0FH
	LD	(CIRFLG),A
	LD	(BELLFLG),A
	JP	TOPAY
	;
DADISP2:DEC	DE
DADISP1:LD	A,(DE)
	LD	(DATA),A
	INC	DE
	LD	A,(DE)
	LD	(DATA+1),A
BELOD:	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;-----------------------------------------
PAY:	LD	A,(JUMPFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENPUN)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(SETFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(JJFLG)
	OR	A
	JP	NZ,DISP
	;
	CALL	CHANDA
	;
	LD	A,(DATA+5)
	AND	0FH
	OR	A
	JP	NZ,PAY1
	LD	A,(DATA+4)
	OR	A
	JP	Z,CLEAR
	LD	HL,DATA
	LD	A,(HL)
	INC	HL
	OR	(HL)
	JR	NZ,PA1
	INC	HL
	OR	(HL)
	JR	NZ,PA1
	JP	CLEAR
	;
PA1:	LD	A,(PAYFLG)
	OR	A
	JP	Z,CLEAR
	;
	CALL	DATOUT
	CALL	SETADR
PAYAA:	LD	A,(DATA+4)
	CPD
	JR	Z,PAYY
	CALL	UUT
	JR	NZ,PAYAA
	JP	CLEAR
	;
PAYY:	LD	(ADDR),DE
	LD	HL,TOTAL	;TOTAL PAY INSERT FOR HUNKUM
	CALL	COMLP
	JP	CLEAR
	;
PAY1:	LD	HL,MENU126
	LD	A,(HL)
	LD	B,A
	INC	HL
	LD	A,(HL)
	OR	B
	JP	Z,CLEAR
	;
	LD	HL,MENU126
	LD	A,(DATA+4)
	CP	(HL)
	JP	NZ,CLEAR
	LD	A,(DATA+5)
	INC	HL
	CP	(HL)
	JP	NZ,CLEAR
	LD	A,0
	LD	(DATA+4),A
	LD	(DATA+5),A
	;
	LD	HL,TOTAL
	LD	DE,DATA
	LD	B,4
PR1:	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	PR1
	LD	A,0FH
	LD	(BELLFLG),A
	LD	(TPAYFLG),A
	JP	DISP
	;-----------------------------
CREDIT: LD	A,(JUMPFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENPUN)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(SETFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(FAFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(JJFLG)
	OR	A
	JP	NZ,DISP
	;
	CALL	CHANDA
	LD	A,(DATA+5)
	AND	0FH
	JP	NZ,CREDIT1
	LD	A,(DATA+4)
	OR	A
	JP	Z,CLEAR
	LD	HL,DATA
	LD	A,(HL)
	INC	HL
	OR	(HL)
	INC	HL
	OR	(HL)
	JR	NZ,CDL1
	JP	CLEAR
	;
CDL1:	LD	A,(PAYFLG)
	OR	A
	JP	Z,CLEAR
	;
	CALL	DATOUT
	;
	CALL	SETADR
CDPAA:	LD	A,(DATA+4)
	CPD
	JR	Z,CDNY
	CALL	UUT
	JR	NZ,CDPAA
	JP	CLEAR
	;
CDNY:	LD	(ADDR),DE
	LD	HL,CDBUFF	;TOTAL PAY INSERT FOR CREDIT
	CALL	COMLP
	JP	CLEAR
	;
CREDIT1:LD	HL,MENU126
	LD	A,(HL)
	LD	B,A
	INC	HL
	LD	A,(HL)
	OR	B
	JP	Z,CLEAR
	;
	LD	HL,MENU126
	LD	A,(DATA+4)
	CP	(HL)
	JP	NZ,CLEAR
	LD	A,(DATA+5)
	INC	HL
	CP	(HL)
	JP	NZ,CLEAR
	LD	A,0
	LD	(DATA+4),A
	LD	(DATA+5),A
	;
	LD	HL,CDBUFF
	LD	DE,DATA
	LD	B,4
CR1:	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	CR1
	LD	A,0FH
	LD	(BELLFLG),A
	LD	(CRFLG),A
	JP	DISP
	;---------------------------------------------
FAPAY:	LD	A,(JUMPFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENPUN)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(SETFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(CRFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(JJFLG)
	OR	A
	JP	NZ,DISP
	;
	CALL	CHANDA
	LD	A,(DATA+5)
	AND	0FH
	JP	NZ,FAPAY1
	LD	A,(DATA+4)
	OR	A
	JP	Z,CLEAR
	LD	HL,DATA
	LD	A,(HL)
	INC	HL
	OR	(HL)
	JR	NZ,FAL1
	INC	HL
	OR	(HL)
	JR	NZ,FAL1
	JP	CLEAR
	;
FAL1:	LD	A,(PAYFLG)
	OR	A
	JP	Z,CLEAR
	;
	CALL	DATOUT
	CALL	SETADR
FAPAA:	LD	A,(DATA+4)
	CPD
	JR	Z,FANY
	CALL	UUT
	JR	NZ,FAPAA
	JP	CLEAR
	;
FANY:	LD	(ADDR),DE
	LD	HL,FABUFF	;TOTAL PAY INSERT FOR CREDIT
	CALL	COMLP
	JP	CLEAR
	;
COMLP:	EX	DE,HL
	CALL	ADD4DG
	;
	LD	B,125
FABY:	INC	HL
	INC	DE
	;
	CALL	ADD2DG
	;
	DJNZ	FABY
	;
TMPAS:	LD	HL,CPDBF
	LD	(HL),7
	LD	DE,TIMGUM+3
CPDTIM: LD	A,(DTIME+1)
	CPD
	JP	Z,TMMOV1
	;
	INC	HL
	LD	A,1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	;
	CP	24H
	JP	Z,TMPAS1
	;
	INC	DE
	INC	DE
	INC	DE
	INC	DE
	JR	CPDTIM
	;
TMMOV1: EX	DE,HL
	LD	DE,(ADDR)
	LD	A,(DE)			;(HL)+(DE)=(DE) X 4 DIGIT
	ADD	A,(HL)
	DAA
	LD	(HL),A
	INC	DE
	DEC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(HL),A
	INC	DE
	DEC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(HL),A
	INC	DE
	DEC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(HL),A
	;
TMPAS1: CALL	INROU
	RET
	;
FAPAY1: LD	HL,MENU126
	LD	A,(HL)
	LD	B,A
	INC	HL
	LD	A,(HL)
	OR	B
	JP	Z,CLEAR
	;
	LD	HL,MENU126
	LD	A,(DATA+4)
	CP	(HL)
	JP	NZ,CLEAR
	LD	A,(DATA+5)
	INC	HL
	CP	(HL)
	JP	NZ,CLEAR
	LD	A,0
	LD	(DATA+4),A
	LD	(DATA+5),A
	;
	LD	HL,FABUFF
	LD	DE,DATA
	LD	B,4
FA1:	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	FA1
	LD	A,0FH
	LD	(BELLFLG),A
	LD	(FAFLG),A
	JP	DISP
	;------------------------------------
INROU:	LD	DE,(ADDR)
	LD	HL,INCOME	;TOTAL PAY INSERT FOR CREDIT
	EX	DE,HL
	CALL	ADD4DG
	;
	LD	B,125
INLP:	INC	HL
	INC	DE
	CALL	ADD2DG
	DJNZ	INLP
	;
	LD	BC,0254
	EX	DE,HL
INERA:	XOR	A
	LD	(DE),A		;WORK BUFFER CLEAR
	DEC	DE
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,INERA
	;
	LD	DE,PRDC
	LD	HL,PDISCO
	XOR	A
	LD	A,(DE)
	ADD	A,(HL)
	DAA
	LD	(HL),A
	INC	HL
	INC	DE
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(HL),A
	INC	HL
	INC	DE
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(HL),A
	INC	HL
	INC	DE
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(HL),A

	RET
	;----------------------------------------------
TAMOV:	LD	A,(DATA+5)	;TABLE MOVEMENT
	AND	0FH
	JP	NZ,CLEAR
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(PAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TPAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENPUN)
	OR	A
	JP	NZ,DISP
	LD	A,(SETFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(CRFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(FAFLG)
	OR	A
	JP	NZ,DISP
	;
	LD	A,0FH
	LD	(TMOVFLG),A
	LD	A,(DATA)
	OR	A
	JR	NZ,MTS
	LD	A,(DATA+4)
	OR	A
	JP	Z,DISP
	LD	A,(DATA+4)
	LD	(DATA),A
	XOR	A
	LD	(DATA+4),A
	;
	CALL	SETADR
BBT:	LD	A,(DATA)
	CPD
	JR	Z,NBS
	CALL	UUT
	JR	NZ,BBT
	JP	CLEAR
	;
NBS:	LD	BC,0254
	LD	(MOVFLG),DE
	LD	HL,WORK
SMC:	LD	A,(DE)
	LD	(HL),A
	INC	DE
	INC	HL
	LD	A,(DE)
	LD	(HL),A
	INC	DE
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,SMC
	JP	BELOD
	;
MTS:	LD	A,(DATA+5)
	AND	0FH
	JP	NZ,CLEAR
	LD	A,(DATA+4)
	LD	B,A
	LD	A,(DATA)
	CP	B
	JP	Z,CLEAR
	;
	LD	A,(DATA+5)
	CALL	SETADR
KNC:	LD	A,(DATA+4)
	CPD
	JR	Z,NTR
	CALL	UUT
	JR	NZ,KNC
	JP	CLEAR
	;
NTR:	LD	HL,WORK
	CALL	ADD4DG
	;
	INC	DE
	INC	HL
	;
	LD	B,125
ORS:	CALL	ADD2DG
	INC	DE
	INC	HL
	DJNZ	ORS
	;
	LD	HL,(MOVFLG)
	LD	A,(HL)
	INC	HL
	OR	(HL)
	JR	NZ,PRESSA
	INC	HL
	LD	A,(HL)
	INC	HL
	OR	(HL)
	JR	Z,PRESSB
	;
PRESSA: CALL	DATAIN
PRESSB: LD	HL,(MOVFLG)
	LD	BC,0254
PK:	XOR	A
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,PK
	;
OUTBS:	LD	HL,WORK
	LD	A,(HL)
	INC	HL
	OR	(HL)
	JR	NZ,PDSA
	INC	HL
	LD	A,(HL)
	INC	HL
	OR	(HL)
	JR	Z,PDSB
	;
PDSA:	CALL	DATOUA
PDSB:	LD	HL,WORK
	LD	BC,0254
PDSC:	XOR	A
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,PDSC
	;
	JP	CLEAR
	;------------------------------
DATAIN: LD	D,0
	LD	A,(DATA+4)
	LD	E,A
	;
DALOOP: XOR	A
	LD	A,E
	SBC	1
	DAA
	LD	E,A
	INC	D
	OR	E
	JR	NZ,DALOOP
	DEC	D
	;
	AND	A
	LD	A,D
	LD	BC,ASEG
	ADD	A,C
	LD	C,A
	LD	A,0
	ADC	A,B
	LD	B,A
	AND	A
	LD	HL,BSEG
	LD	A,D
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	XOR	A
	LD	A,(HL)
	LD	HL,LABUFF
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	LD	A,(BC)
	OR	A,(HL)
	LD	(HL),A
	RET
	;
DATOUA: LD	D,0
	LD	A,(DATA)
	LD	E,A
	JR	OULOOP
	;
DATOUT: LD	D,0
	LD	A,(DATA+4)
	LD	E,A
	;
OULOOP: XOR	A
	LD	A,E
	SBC	1
	DAA
	LD	E,A
	INC	D
	OR	E
	JR	NZ,OULOOP
	DEC	D
	;
	XOR	A
	LD	A,D
	LD	BC,ASEG
	ADD	A,C
	LD	C,A
	LD	A,0
	ADC	A,B
	LD	B,A
	AND	A
	LD	HL,BSEG
	LD	A,D
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	AND	A
	LD	A,(HL)
	LD	HL,LABUFF
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	LD	A,(BC)
	XOR	(HL)
	LD	(HL),A
	RET
	;
CHANDA: LD	A,(GIVEON)
	OR	A
	JR	NZ,CHAD1
	RET
	;
CHAD1:	LD	HL,AREA
	LD	DE,DATA
	LD	B,4
CHAD2:	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	CHAD2
	LD	A,0
	LD	(GIVEON),A
	RET
	;
	;-------------------------------------------------
TIM0:	DI
	PUSH	AF		;INTERRUPT SERVICE ROUTINE
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX
	PUSH	IY
	;
	LD	BC,TCR
	IN	A,(C)
	LD	BC,TMDR0L
	IN	A,(C)
	LD	BC,TMDR0H
	IN	A,(C)
	;
	XOR	A
	OUT	(SEVEN),A
	OUT	(PTA),A
	OUT	(PTB),A
	OUT	(PTC),A
	DEC	A
	OUT	(LATCH),A
	;
	LD	HL,LEDCNT
	LD	A,(HL)
	LD	B,0		;DISPLAY ROUTINE
	LD	C,A
	LD	A,(DISPFLG)	;PASS WORD ON / OFF
	OR	A
	JR	Z,NORDISP
	LD	A,C
	SUB	8
	JR	NC,NORDISP	;LED0 LED1 LED2 LED3 ALL OFF
	LD	A,11
	LD	C,A
NORDISP:LD	HL,COMMON
	ADD	HL,BC
	LD	A,(HL)
	OUT	(LATCH),A
	LD	HL,LEDS
	ADD	HL,BC
	LD	A,(HL)
	OUT	(SEVEN),A
	;
LDIS1:	LD	HL,LACNT
	LD	DE,COMA
	AND	A
	LD	A,(HL)
	LD	B,A
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	LD	A,B
	SUB	8
	JR	NC,LDIS2
	;
	LD	A,(DE)
	OUT	(PTA),A
	JR	LDIS3
	;
LDIS2:	LD	A,(DE)
	OUT	(PTB),A
	;
LDIS3:	AND	A
	LD	DE,LABUFF
	LD	A,B
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	LD	A,(DE)
	OUT	(PTC),A
	LD	HL,LEDCNT
	INC	(HL)
	LD	A,(HL)
	SUB	11
	JR	C,LED1
	LD	(HL),A
	;
LED1:	LD	HL,LACNT
	INC	(HL)
	LD	A,(HL)
	SUB	13
	JR	C,KBOARD
	LD	(HL),A
	;
KBOARD: LD	HL,INTCNT	;KEY SCANNING
	LD	A,(HL)
	SUB	4
	JP	C,INTRET
	LD	(HL),A
	CALL	KEY
	LD	A,(BELLFLG)
	OR	A
	JR	Z,INTRET
	CP	0FH
	CALL	Z,BELON
	INC	A
	LD	(BELLFLG),A
	CP	27H
	CALL	Z,BELOF
	;
INTRET: LD	HL,INTCNT
	INC	(HL)
	LD	HL,INCNT
	INC	(HL)
	LD	A,(HL)
	SUB	30
	JR	NZ,INTRA
	LD	(HL),A
	LD	HL,CLKO
	INC	(HL)
	CALL	READ
	CALL	CONTM
	;
INTRA:	LD	A,(HOUFLG)
	LD	B,A
	LD	A,(MONFLG)
	OR	B
	JR	Z,INTRB
	;
	LD	HL,(FLASH)
	INC	HL
	LD	(FLASH),HL
	;
INTRB:	POP	IY
	POP	IX
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	EI
	RETI
	;----------------------------------------------
BELON:	PUSH	AF
	LD	A,0FFH
	OUT	(BELLON),A
	POP	AF
	RET
	;
BELOF:	LD	A,0
	OUT	(BELLON),A
	RET
	;----------------------------------------------
KEY:	LD	A,(FUNFLG)
	OR	A
	JR	NZ,PSSB
	IN	A,(FUNKEY)
	BIT	7,A
	JR	NZ,PSSA
	LD	A,0FH
	LD	(FUNFLG),A
	JR	PSSB
PSSA:	LD	A,0
	LD	(FUNFLG),A
	;
PSSB:	LD	A,0		;KEY SCANNING ROUTINE
	OUT	(PORTB),A
	IN	A,(PORTC)
	CPL
	OR	A
	JR	NZ,KEYSER	;JUMP KEY SCANNING OF KEY ON
	LD	A,0
	LD	(KEYFLG),A
KRET:	NOP
	RET
	;
KEYSER: LD	A,(KEYFLG)
	OR	A
	JR	Z,KEYSCA
	RET
	;
KEYSCA: PUSH	DE
	PUSH	BC
	LD	B,8
	LD	C,7FH
KLOOP:	LD	A,C
	OUT	(PORTB),A
	IN	A,(PORTC)
	CPL
	OR	A
	JR	NZ,KEYON
	RRC	C
	DJNZ	KLOOP
	POP	BC
	POP	DE
	JR	KRET
	;
KEYON:	DEC	B
	LD	E,0
	;
KLOOP1: RRCA
	INC	E
	JR	NC,KLOOP1
	DEC	E
	LD	A,E
	RLCA
	RLCA
	RLCA
	ADD	A,B
	POP	BC
	POP	DE
	OR	A
	LD	(KEYDATA),A
	LD	A,0FH
	LD	(KEYFLG),A
	LD	(ACTFLG),A
	RET
	;----------------------------------------------
ADDT3:	LD	DE,WORK 	;4 BYTE ADDTION
	AND	A
	LD	A,(DE)
	ADD	A,(HL)
	DAA
	LD	(DE),A
	INC	DE
	INC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(DE),A
	INC	DE
	INC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(DE),A
	INC	DE
	LD	A,(DE)
	ADC	A,0
	DAA
	LD	(DE),A
	RET
	;
SETMEN: IN	A,(PPC) 	;KEY ON = N    KEY OFF = M
	BIT	7,A
	JP	NZ,DISP
	;
	LD	A,(TMEFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(JUMPFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(PAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TPAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENPUN)
	OR	A
	JP	NZ,DISP
	LD	A,(TABPUN)
	OR	A
	JP	Z,DISP
	;
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(SETFLG)
	OR	A
	JR	NZ,SETACT
	LD	A,0FH
	LD	(SETFLG),A
	;
	LD	A,(DATA+5)
	CP	2
	JP	NC,CLEAR
	CP	1
	JR	C,PASSET1
	LD	A,(DATA+4)
	CP	27H
	JP	NC,CLEAR
	;
	LD	DE,MENU100
	LD	HL,CPDBF
	LD	(HL),0
	LD	BC,0027 	  ;100 TO 125
	JR	SSLOP
	;
PASSET1:LD	A,(DATA+4)
	LD	DE,MENU1
	LD	HL,CPDBF
	LD	BC,0099 	  ;1 TO 99
	;
SSLOP:	LD	A,(DATA+4)
	CPD
	JR	Z,SSMOV
	INC	HL
	LD	A,1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	INC	DE
	INC	DE
	INC	DE
	LD	A,C
	OR	B
	JR	NZ,SSLOP
	;
SSBEL:	LD	A,0FH
	LD	(BELLFLG),A
	LD	(CLEFLG),A
	JP	DISP
	;
SSMOV:	LD	A,(DE)
	LD	(DATA),A
	INC	DE
	LD	A,(DE)
	LD	(DATA+1),A
	INC	DE
	LD	A,(DE)
	LD	(DATA+2),A
	JP	SSBEL
	;
SETACT: LD	A,0
	LD	(CLEFLG),A
	LD	A,(DATA+5)
	CP	2
	JP	NC,CLEAR
	CP	1
	JR	NZ,PASSET2
	;
	LD	DE,MENU100
	LD	HL,CPDBF
	LD	(HL),0
	LD	BC,27		;100 TO 125
	JR	SETMLOP
	;
PASSET2:LD	DE,MENU1
	LD	HL,CPDBF
	LD	BC,99		;1 TO 99
SETMLOP:LD	A,(DATA+4)
	CPD
	JR	Z,SETMOV
	INC	HL
	LD	A,1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	INC	DE
	INC	DE
	INC	DE
	;
	LD	A,C
	OR	B
	JR	NZ,SETMLOP
	JP	CLEAR
	;
SETMOV: LD	A,(DATA)
	LD	(DE),A
	LD	A,(DATA+1)
	INC	DE
	LD	(DE),A
	INC	DE
	LD	A,(DATA+2)
	LD	(DE),A
	JP	CLEAR
	;
	;
ALLCLE: LD	A,(PAYFLG)
	OR	A
	JP	NZ,GIVMON
	;
	IN	A,(PPC) 	;KEY ON = A   KEY OFF = B
	BIT	7,A
	JP	NZ,DISP
	;
	DI
BLLCLE: LD	A,(TMEFLG)	;KEY ON = B   KEY OFF = A
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(PAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TPAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENPUN)
	OR	A
	JP	NZ,DISP
	;
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	;
	LD	A,(DATA+5)
	OR	A
	JP	NZ,DISP
	LD	A,(DATA+4)
	OR	A
	JP	NZ,DISP
	LD	A,0FH
	LD	(SETFLG),A
	LD	A,(DISPFLG)
	OR	A
	JP	NZ,ONEACT
	;
	LD	A,0FH
	LD	(DISPFLG),A
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;
ONEACT: LD	HL,DATA+1
	LD	A,(PASS+1)
	CP	(HL)
	JR	NZ,NOERA
	DEC	HL
	LD	A,(PASS)
	CP	(HL)
	JR	NZ,NOERA
	;
	LD	A,0FH
	OUT	(BELLON),A
	LD	A,0		;WORKBF AND TOTALBF
	OUT	(SEVEN),A
	DEC	A
	OUT	(LATCH),A
	INC	A
	;
	LD	HL,JUNNO+1
ERLOOP: XOR	A
	LD	(HL),A
	DEC	HL
	LD	A,H
	CP	80H
	JR	NZ,ERLOOP
	LD	A,L
	OR	A
	JR	NZ,ERLOOP
	LD	A,1
	LD	(PWRON),A
	JP	CLEAR
	;
NOERA:	LD	HL,DATA
	LD	A,0
	LD	(HL),A
	INC	HL
	LD	(HL),A
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;
GIVMON: LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(GIVACT)
	OR	A
	JP	NZ,DISP
	LD	A,(GIVEFLG)
	OR	A
	JP	NZ,GIV1
	LD	A,0FH
	LD	(GPASS),A
	LD	(GIVEFLG),A
	LD	A,(DATA)
	LD	(AREA),A
	LD	A,(DATA+1)
	LD	(AREA+1),A
	LD	A,(DATA+2)
	LD	(AREA+2),A
	LD	A,(DATA+3)
	LD	(AREA+3),A
	LD	A,0
	LD	(DATA),A
	LD	(DATA+1),A
	LD	(DATA+2),A
	LD	(DATA+3),A
	LD	A,0FH
	LD	(BELLFLG),A
	LD	(GIVEON),A
	JP	DISP
	;
GIV1:	LD	HL,AREA+4
	LD	DE,DATA+4
GIV2:	DEC	HL
	DEC	DE
	LD	B,5
	DEC	B
	LD	A,B
	OR	B
	JP	Z,GIV3
	XOR	A
	LD	A,(DE)
	OR	A
	JR	Z,GIV2
	;
	DEC	HL
	DEC	DE
	LD	A,(DE)
	SUB	A,(HL)
	DAA
	INC	HL
	INC	DE
	LD	A,(DE)
	SBC	A,(HL)
	DAA
	JP	C,GIV3
	;
	LD	A,(DATA)
	LD	(GIVMDA),A
	LD	A,(DATA+1)
	LD	(GIVMDA+1),A
	LD	A,(DATA+2)
	LD	(GIVMDA+2),A
	LD	A,(DATA+3)
	LD	(GIVMDA+3),A
	LD	A,0FH
	LD	(GIVACT1),A
	;
	LD	HL,AREA
	LD	DE,DATA
	XOR	A
	LD	A,(DE)
	SUB	A,(HL)
	DAA
	LD	(DE),A
	INC	HL
	INC	DE
	LD	A,(DE)
	SBC	A,(HL)
	DAA
	LD	(DE),A
	INC	HL
	INC	DE
	LD	A,(DE)
	SBC	A,(HL)
	DAA
	LD	(DE),A
	INC	HL
	INC	DE
	LD	A,(DE)
	SBC	A,(HL)
	DAA
	LD	(DE),A
	LD	A,0FH
	LD	(GIVACT),A
GIV3:	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;----------------------------------------------
	DEFB	0,0,0,0,0,0,0,0
ASEG:	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	DEFB	1,2,4,8,10H,20H,40H,80H
	;
BSEG:	DEFB	0,0,0,0,0,0,0,0
	DEFB	1,1,1,1,1,1,1,1
	DEFB	2,2,2,2,2,2,2,2
	DEFB	3,3,3,3,3,3,3,3
	DEFB	4,4,4,4,4,4,4,4
	DEFB	5,5,5,5,5,5,5,5
	DEFB	6,6,6,6,6,6,6,6
	DEFB	7,7,7,7,7,7,7,7
	DEFB	8,8,8,8,8,8,8,8
	DEFB	9,9,9,9,9,9,9,9
	DEFB	0AH,0AH,0AH,0AH,0AH,0AH,0AH,0AH
	DEFB	0BH,0BH,0BH,0BH,0BH,0BH,0BH,0BH
	DEFB	0CH,0CH,0CH,0CH,0CH,0CH,0CH,0CH
	;
	;
READ:	LD	A,0
	LD	C,0BDH
	OUT	(C),A
	;
	LD	C,0B2H		   ;MINUTE
	CALL	RDSUB
	LD	L,A
	LD	C,0B4H		   ;HOUR
	CALL	RDSUB
	LD	H,A
	CP	24H
	JR	C,HOURPAS
	LD	A,0
	LD	H,A
	;
HOURPAS:LD	(CLOCK),HL
	;
	LD	C,0B7H		   ;DATE
	CALL	RDSUB
	LD	L,A
	LD	C,0B9H		   ;MONTH
	CALL	RDSUB
	LD	H,A
	LD	(DATE),HL
	LD	C,0BBH		   ;YEAR
	CALL	RDSUB
	LD	(DATE+2),A
	;
	LD	C,0BDH
	LD	A,08
	OUT	(C),A
	RET
	;
RDSUB:	IN	A,(C)
	AND	0FH
	LD	B,A
	INC	C
	IN	A,(C)
	SLA	A
	SLA	A
	SLA	A
	SLA	A
	OR	B
	RET
	;
WRIT1:	LD	A,0FH
	LD	(HOUFLG),A
	LD	A,0
	LD	(MONFLG),A
	;
	LD	C,0BDH
	LD	A,00
	OUT	(C),A
	;
	LD	C,0B2H
	CALL	RDSUB
	ADD	A,1
	DAA
	CP	60H
	JR	C,WRITM
	XOR	A
	;
WRITM:	LD	B,A
	LD	C,0B2H
	CALL	WRSUB
	LD	A,0FH
	LD	(BELLFLG),A
	LD	C,0BDH
	LD	A,08
	OUT	(C),A
	RET
	;
WRIT2:	LD	A,0FH
	LD	(HOUFLG),A
	LD	A,0
	LD	(MONFLG),A
	;
	LD	C,0BDH
	LD	A,00
	OUT	(C),A
	;
	LD	C,0B4H
	CALL	RDSUB
	ADD	A,1
	DAA
	LD	B,A
	CP	24H
	JR	C,HORPS
	LD	B,0
	;
HORPS:	LD	C,0B4H
	CALL	WRSUB
	LD	A,0FH
	LD	(BELLFLG),A
	LD	C,0BDH
	LD	A,08
	OUT	(C),A
	RET
	;
WRIT3:	LD	A,0FH
	LD	(MONFLG),A
	LD	A,0
	LD	(HOUFLG),A
	;
	LD	C,0BDH
	LD	A,00
	OUT	(C),A
	;
	LD	C,0B7H
	CALL	RDSUB
	ADD	A,1
	DAA
	CP	32H
	JR	C,WRITC
	;
	LD	A,1
	;
WRITC:	LD	B,A
	LD	C,0B7H
	CALL	WRSUB
	LD	A,0FH
	LD	(BELLFLG),A
	LD	C,0BDH
	LD	A,08
	OUT	(C),A
	RET
	;
WRIT4:	LD	A,0FH
	LD	(MONFLG),A
	LD	A,0
	LD	(HOUFLG),A
	;
	LD	C,0BDH
	LD	A,00
	OUT	(C),A
	;
	LD	C,0B9H
	CALL	RDSUB
	ADD	A,1
	DAA
	CP	13H
	JR	C,WRITF
	LD	A,1
	;
WRITF:	LD	B,A
	LD	C,0B9H
	CALL	WRSUB
	LD	A,0FH
	LD	(BELLFLG),A
	LD	C,0BDH
	LD	A,08
	OUT	(C),A
	RET
	;
WRIT5:	LD	A,0FH
	LD	(MONFLG),A
	LD	A,0
	LD	(HOUFLG),A
	;
	LD	C,0BDH
	LD	A,00
	OUT	(C),A
	;
	LD	C,0BBH
	CALL	RDSUB
	ADD	A,1
	DAA
	LD	B,A
	LD	C,0BBH
	CALL	WRSUB
	;
	LD	A,09		;MODE 1
	LD	C,0BDH
	OUT	(C),A
	;
	LD	A,01		;24 HOUR
	LD	C,0BAH
	OUT	(C),A
	INC	C
	LD	A,0
	OUT	(C),A
	;
	LD	A,0FH
	LD	(BELLFLG),A
	LD	C,0BDH
	LD	A,08
	OUT	(C),A
	RET
	;
WRSUB:	LD	A,B
	OUT	(C),A
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	INC	C
	OUT	(C),A
	RET
	;
CONTM:	LD	HL,CLOCK+1
	LD	DE,DTIME+1
CONRET: LD	A,(HL)
	LD	(DE),A
	DEC	HL
	DEC	DE
	LD	A,(HL)
	LD	(DE),A
	RET
	;
TMDIS1: LD	A,0FH
	LD	(HOUFLG),A
	LD	A,0
	LD	(MONFLG),A
	LD	A,0FH
	LD	(BELLFLG),A
	RET
	;
TMDIS2: LD	A,0FH
	LD	(MONFLG),A
	LD	A,0
	LD	(HOUFLG),A
	LD	A,0FH
	LD	(BELLFLG),A
	RET
	;
	;PRINTER CONTROLLER  *****************************
STARTP: IN	A,(PPC)
	BIT	6,A
	RET	NZ
	;
	PUSH	HL
	PUSH	BC
	PUSH	DE
	LD	HL,TRANBF
	LD	BC,(TBYTE)
	;
CHECK:	IN	A,(PPC)
	BIT	4,A
	JR	NZ,CHECK
	;
	LD	A,(HL)
	OUT	(PPA),A
	RES	0,A
	OUT	(PPC),A
	;
	SET	0,A
	OUT	(PPC),A
	;
	PUSH	AF
	LD	A,15
DECACC: DEC	A
	JR	NZ,DECACC
	POP	AF
	;
	DEC	BC
	INC	HL
	LD	A,B
	OR	C
	JR	NZ,CHECK
	POP	DE
	POP	BC
	POP	HL
	RET
	;
STARTS: IN	A,(PPC)
	BIT	5,A
	RET	NZ
	;
	PUSH	HL
	PUSH	BC
	PUSH	DE
	LD	HL,TRANBF
	LD	DE,(TBYTE)
	;
CTSCHK: LD	BC,CNTLB0	 ;CTS READY
	IN	A,(C)
	BIT	5,A
	JR	NZ,CTSCHK
	;
TRBFCHK:LD	BC,STAT0
	IN	A,(C)
	BIT	1,A
	JR	Z,TRBFCHK
	;
	LD	A,(HL)
	LD	BC,TDR0
	OUT	(C),A
	INC	HL
	DEC	DE
	LD	A,D
	OR	E
	JR	NZ,CTSCHK
	;
	POP	DE
	POP	BC
	POP	HL
	RET
	;
STARTT: IN	A,(POTST)
	BIT	0,A
	RET	NZ
	;
	PUSH	HL
	PUSH	BC
	PUSH	DE
	LD	HL,TRANBF
	LD	DE,(TBYTE)
	;
CTSCHK1:LD	BC,CNTLB1	 ;CTS READY
	IN	A,(C)
	BIT	5,A
	JR	NZ,CTSCHK1
	;
TRBCHK1:LD	BC,STAT1
	IN	A,(C)
	BIT	1,A
	JR	Z,TRBCHK1
	;
	LD	A,(HL)
	LD	BC,TDR1
	OUT	(C),A
	INC	HL
	DEC	DE
	LD	A,D
	OR	E
	JR	NZ,CTSCHK1
	;
	POP	DE
	POP	BC
	POP	HL
	RET
	;
STARTU: IN	A,(POTST)
	BIT	2,A
	RET	NZ
	;
	PUSH	HL
	PUSH	BC
	PUSH	DE
	LD	HL,TRANBF
	LD	BC,(TBYTE)
	;
TXRDYU: IN	A,(STAT2)
	BIT	7,A
	JR	Z,TXRDYU
	;
TXRDYU1:IN	A,(STAT2)
	BIT	0,A
	JR	Z,TXRDYU1
	;
	LD	A,(HL)
	OUT	(DATA1),A
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,TXRDYU
	;
	POP	HL
	POP	BC
	POP	DE
	RET
	;
AFCLE:	LD	A,26
	LD	(TBYTE),A
	LD	A,00
	LD	(TBYTE+1),A
	;
	PUSH	HL
	PUSH	BC
	LD	HL,TRANBF
	LD	(HL),11H
	INC	HL
	LD	(HL),1BH
	INC	HL
	LD	(HL),31H
	INC	HL
	LD	(HL),0EH
	INC	HL
	;
	LD	BC,46
ALP:	LD	(HL),20H
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,ALP
	LD	HL,TRANBF+25
	LD	(HL),0DH
	INC	HL
	LD	(HL),0AH
	POP	BC
	POP	HL
	RET
	;
BFCLE:	LD	A,45
	LD	(TBYTE),A
	LD	A,00
	LD	(TBYTE+1),A
	;
	PUSH	HL
	PUSH	BC
	LD	HL,TRANBF
	LD	(HL),11H
	INC	HL
	LD	(HL),1BH
	INC	HL
	LD	(HL),31H
	INC	HL
	;
	LD	BC,40
BLP:	LD	(HL),20H
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,BLP
	LD	(HL),0DH
	INC	HL
	LD	(HL),0AH
	POP	BC
	POP	HL
	RET
	;
PRBCLE: PUSH	HL
	PUSH	BC
	LD	HL,PRYUNG
	LD	BC,0500 	;4 * 125 = 500
CLP:	LD	A,0
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,CLP
	POP	BC
	POP	HL
	RET
	;
YUNGA:	LD	DE,MPB
	LD	HL,MPB1
	LD	BC,375
YULPA:	LD	A,(DE)
	LD	(HL),A
	INC	DE
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,YULPA
	;
	LD	HL,PRYUNG+3
	LD	(PRYUBF),HL
	LD	DE,MPB1
	LD	(PRDEBF),DE
YUNGB:	LD	DE,(PRDEBF)
	LD	A,(DE)
	OR	A
	RET	Z
	;
	LD	HL,MENU1
	DEC	A
	LD	B,A
	OR	A
	JR	Z,YUNGC
	;
INCLP:	INC	HL
	INC	HL
	INC	HL
	LD	A,B
	DEC	A
	LD	B,A
	OR	A
	JR	NZ,INCLP
	;
YUNGC:	LD	(PRDEBF),DE
	LD	(PRHLBF),HL
	LD	BC,(PRDEBF)
	LD	DE,(PRHLBF)
	LD	HL,(PRYUBF)
	INC	BC
	LD	A,(BC)
	OR	A
	JR	NZ,YUX1
	INC	BC
	LD	A,(BC)
	OR	A
	JR	NZ,YUX2
	RET
	;
YUX1:	INC	BC
YUX2:	XOR	A
	LD	A,(BC)
	SUB	1
	DAA
	LD	(BC),A
	DEC	BC
	LD	A,(BC)
	SBC	A,0
	DAA
	LD	(BC),A
	;
YUXLP1: AND	A
	PUSH	DE
	PUSH	HL
	LD	A,(DE)
	ADD	A,(HL)
	DAA
	LD	(HL),A		;1
	;
	INC	DE
	DEC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(HL),A		;2
	;
	INC	DE
	DEC	HL
	LD	A,(DE)
	ADC	A,(HL)
	DAA
	LD	(HL),A		;3
	;
	DEC	HL
	LD	A,0
	ADC	A,(HL)
	DAA
	LD	(HL),A		;4
	;
	POP	HL
	POP	DE
	;
	LD	A,(BC)
	OR	A
	JR	NZ,YUX1
	INC	BC
	LD	A,(BC)
	OR	A
	JR	NZ,YUX2
	INC	HL
	INC	HL
	INC	HL
	INC	HL
	LD	(PRYUBF),HL
	;
	INC	BC
	LD	(PRDEBF),BC
	JP	YUNGB
	;------------------------------------------------
PRINTY: CALL	BFCLE
	CALL	TIMSAV
	XOR	A
	LD	A,1		;PRINT NO INC.
	LD	HL,PRYNG+1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	DEC	HL
	LD	A,0
	ADC	A,(HL)
	DAA
	LD	(HL),A
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	CALL	AFCLE
	;
	LD	HL,TRANBF+4
	LD	DE,KEISAN
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,FIRM
	CALL	MOVE20
	;
	LD	HL,TRANBF+26
	LD	(HL),'T'
	INC	HL
	LD	(HL),'.'
	INC	HL
	LD	(HL),'N'
	INC	HL
	LD	(HL),'O'
	INC	HL
	LD	(HL),':'
	INC	HL
	LD	BC,DATA+4
	CALL	ASCVTN2
	;
	LD	HL,TRANBF+35
	LD	(HL),'N'
	INC	HL
	LD	(HL),'O'
	INC	HL
	LD	(HL),':'
	INC	HL
	LD	BC,PRYNG
	CALL	ASCVTT4
	;
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,ADDRESS
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,NAME
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,TELNO
	CALL	MOVE14
	LD	HL,TRANBF+25
	LD	DE,PRTIME
	CALL	MOVE18
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,PMSUGU
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	MPBCLE
	CALL	PRBCLE
	LD	HL,WORK+4
	CALL	PRMOD
	CALL	YUNGA
	CALL	YUMENU
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	MOVBNK
	CALL	STARTP
	CALL	BFCLE
	;
	LD	DE,PRDC+3
	LD	A,(DE)
	LD	B,A
	DEC	DE
	LD	A,(DE)
	ADD	B
	JR	NZ,PRTDC
	;
	DEC	DE
	LD	A,(DE)
	LD	B,A
	DEC	DE
	LD	A,(DE)
	ADD	B
	JR	NZ,PRTDC
	JR	PRNOT
	;
PRTDC:	LD	DE,WORK+3
	CALL	AFCLE
	CALL	CONSUM1
	CALL	SOKEI
	CALL	CONSUM3
	CALL	STARTP
	CALL	AFCLE
	;
	LD	DE,PRDC+3
	CALL	AFCLE
	CALL	CONSUM1
	CALL	HALIN
	CALL	CONSUM3
	CALL	STARTP
	;
PRNOT:	CALL	AFCLE
	LD	HL,PRDC
	LD	A,(HL)
	INC	HL
	OR	(HL)
	INC	HL
	OR	(HL)
	INC	HL
	OR	(HL)
	JR	Z,AMTPA
	LD	DE,PRAMT+3
	JR	AMTPB
	;
AMTPA:	LD	DE,WORK+3
AMTPB:	CALL	CONSUM1
	CALL	CONSUM2
	CALL	STARTP
	CALL	BFCLE
	;
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	RET
	;----------------------------------------------
CONSUM1:LD	HL,PRWORK
	;
	LD	B,4
CONLOP: LD	A,(DE)		;(DE)=DECIMAL
	PUSH	AF		;(HL)=ASC II
	AND	0F0H
	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	INC	HL
	POP	AF
	AND	0FH
	OR	A,30H
	LD	(HL),A
	INC	HL
	DEC	DE
	DJNZ	CONLOP
	RET
	;
CONSUM2:LD	A,0D0H
	LD	(TRANBF+9),A
	LD	A,73H
	LD	(TRANBF+10),A
	LD	A,89H
	LD	(TRANBF+11),A
	LD	A,81H
	LD	(TRANBF+12),A
	;
CONSUM3:LD	HL,TRANBF+16
	LD	DE,PRWORK
	LD	C,8
	LD	B,8
MMMP:	LD	A,(DE)
	SUB	30H
	JR	NZ,LLLP
	INC	HL
	INC	DE
	DEC	C
	DJNZ	MMMP
	RET
	;
LLLP:	LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	LLLP
	;
	AND	A
	LD	A,C
	SUB	7
	JR	NC,JUM2
	LD	A,C
	SUB	4
	JR	NC,JUM1
	RET
	;
JUM2:	LD	HL,TRANBF+16
	LD	DE,TRANBF+14
	LD	B,2
JUMLP2: LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	JUMLP2
	LD	A,2CH
	LD	(TRANBF+16),A
	;
JUM1:	LD	HL,TRANBF+18
	LD	DE,TRANBF+17
	LD	B,3
JUMLP1: LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	JUMLP1
	LD	A,2CH
	LD	(TRANBF+20),A
	RET
	;--------------------------------------------------
SOKEI:	LD	A,173
	LD	(TRANBF+9),A
	LD	A,161
	LD	(TRANBF+10),A
	LD	A,137
	LD	(TRANBF+11),A
	LD	A,129
	LD	(TRANBF+12),A
	RET
	;
HALIN:	LD	A,208
	LD	(TRANBF+9),A
	LD	A,105
	LD	(TRANBF+10),A
	LD	A,183
	LD	(TRANBF+11),A
	LD	A,165
	LD	(TRANBF+12),A
	RET
	;
	;--------------------------------------------------
ONEDAY: IN	A,(PPC) 	;KEY ON = N    KEY OFF = M
	BIT	7,A
	JP	NZ,DISP
	;
TNEDAY: LD	A,(TMEFLG)	;KEY ON = M    KEY OFF = N
	OR	A
	JP	NZ,DISP
	LD	A,(MENUFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(PAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TPAYFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(TMOVFLG)
	OR	A
	JP	NZ,DISP
	LD	A,(MENPUN)
	OR	A
	JP	NZ,DISP
	;
	LD	A,(MUXFLG)
	OR	A
	JP	NZ,DISP
	;
	LD	A,(DATA+5)
	OR	A
	JP	NZ,DISP
	LD	A,(DATA+4)
	OR	A
	JP	NZ,DISP
	LD	A,0FH
	LD	(SETFLG),A
	LD	A,(DISPFLG)
	OR	A
	JP	NZ,TOWACT
	;
	LD	A,0FH
	LD	(DISPFLG),A
	LD	A,0FH
	LD	(BELLFLG),A
	JP	DISP
	;
TOWACT: LD	HL,DATA+1
	LD	A,(PASS+1)
	CP	(HL)
	JP	NZ,CLEAR
	DEC	HL
	LD	A,(PASS)
	CP	(HL)
	JP	NZ,CLEAR
	;
	LD	HL,TAB1
	LD	BC,1
	;
OINLOP: LD	A,(HL)
	INC	HL
	OR	A,(HL)
	JP	NZ,MOVCALL
	;
ONLOP:	XOR	A
	LD	A,1
	ADD	A,C
	DAA
	LD	C,A
	LD	A,0
	ADC	A,B
	DAA
	LD	B,A
	LD	A,00H
	CP	C
	JP	NZ,ONLOP1
	LD	A,1
	CP	B
	JP	Z,MOVPAS
	;
ONLOP1: XOR	A
	DEC	HL
	LD	A,254
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	JP	OINLOP
	;
MOVCALL:LD	A,(CNRFLG)
	OR	A
	JR	NZ,MOVPAS
	;
	LD	A,0FH
	LD	(CNRFLG),A
	CALL	MOVMASG
	JP	CLEAR
	;
	;-----------------------
MOVPAS: CALL	TIMSAV
	XOR	A
	LD	A,1
	LD	HL,JJNO+1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	DEC	HL
	LD	A,0
	ADC	A,(HL)
	DAA
	LD	(HL),A
	;
	LD	A,0
	LD	(CNRFLG),A
	CALL	BFCLE
	CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,KYULSAN
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;=================================
	LD	HL,TRANBF+16
	LD	DE,JEJE
	CALL	MOVE14
	LD	HL,TRANBF+25
	LD	BC,JJNO
	;
	CALL	ASCVTT4
	;
	CALL	STARTP
	;=================================
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,FIRM
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,ADDRESS
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,NAME
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,TELNO
	CALL	MOVE14
	LD	HL,TRANBF+25
	LD	DE,PRTIME
	CALL	MOVE18	     ;MOVE10
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,TONGHAB
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,PMSUGU
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	MPBCLE
	CALL	PRBCLE
	LD	HL,INCOME+4
	CALL	PRMOD
	CALL	YUNGA
	CALL	YUMENU
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	AFCLE
	LD	DE,INCOME+3
	CALL	CONSUM1
	;
	LD	A,0A0H
	LD	(TRANBF+5),A
	LD	A,81H
	LD	(TRANBF+6),A
	LD	A,0C2H
	LD	(TRANBF+7),A
	LD	A,89H
	LD	(TRANBF+8),A
	LD	A,0C1H
	LD	(TRANBF+9),A
	LD	A,0B7H
	LD	(TRANBF+10),A
	LD	A,0B4H
	LD	(TRANBF+11),A
	LD	A,82H
	LD	(TRANBF+12),A
	;
	CALL	CONSUM3
	CALL	STARTP
	;
	LD	DE,CDBUFF+3
	CALL	AFCLE
	CALL	CONSUM1
	LD	A,0AFH
	LD	(TRANBF+9),A
	LD	A,0A5H
	LD	(TRANBF+10),A
	LD	A,0B6H
	LD	(TRANBF+11),A
	LD	A,77H
	LD	(TRANBF+12),A
	;
	CALL	CONSUM3
	CALL	STARTP
	;
	LD	DE,FABUFF+3
	CALL	AFCLE
	CALL	CONSUM1
	LD	A,0B6H
	LD	(TRANBF+9),A
	LD	A,41H
	LD	(TRANBF+10),A
	LD	A,0ACH
	LD	(TRANBF+11),A
	LD	A,77H
	LD	(TRANBF+12),A
	;
	CALL	CONSUM3
	CALL	STARTP
	;
	CALL	AFCLE
	LD	DE,PDISCO+3
	CALL	CONSUM1
	CALL	HALIN
	CALL	CONSUM3
	CALL	STARTP
	CALL	PRBCLE
	;
	LD	DE,TOTAL+3
	CALL	AFCLE
	CALL	CONSUM1
	LD	A,0D1H
	LD	(TRANBF+9),A
	LD	A,65H
	LD	(TRANBF+10),A
	LD	A,8BH
	LD	(TRANBF+11),A
	LD	A,71H
	LD	(TRANBF+12),A
	;
	CALL	CONSUM3
	CALL	STARTP
	;
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,2
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	CALL	PRBCLE
	CALL	MPBCLE
	;----------------------------
     ;	JP	CREACNT 	    ; HYUNGUM DELETE
	;----------------------------
CASACNT:CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,HYUNGUM
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,PMSUGU
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	MPBCLE
	CALL	PRBCLE
	LD	HL,TOTAL+4
	CALL	PRMOD
	CALL	YUNGA
	CALL	YUMENU
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	MOVBNK
	CALL	STARTP
	CALL	BFCLE
	;
	LD	DE,TOTAL+3
	CALL	AFCLE
	CALL	CONSUM1
	CALL	CONSUM2
	CALL	STARTP
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,2
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	CALL	PRBCLE
	CALL	MPBCLE
	;----------------------------
CREACNT:CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,SHINYNG
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,PMSUGU
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	MPBCLE
	CALL	PRBCLE
	LD	HL,CDBUFF+4
	CALL	PRMOD
	CALL	YUNGA
	CALL	YUMENU
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	MOVBNK
	CALL	STARTP
	CALL	BFCLE
	;
	LD	DE,CDBUFF+3
	CALL	AFCLE
	CALL	CONSUM1
	CALL	CONSUM2
	CALL	STARTP
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,2
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	CALL	PRBCLE
	CALL	MPBCLE
	;----------------------------
FAYACNT:CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,OISANG
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,PMSUGU
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	MPBCLE
	CALL	PRBCLE
	LD	HL,FABUFF+4
	CALL	PRMOD
	CALL	YUNGA
	CALL	YUMENU
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	MOVBNK
	CALL	STARTP
	CALL	BFCLE
	;
	LD	DE,FABUFF+3
	CALL	AFCLE
	CALL	CONSUM1
	CALL	CONSUM2
	CALL	STARTP
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,2
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	CALL	PRBCLE
	CALL	MPBCLE
	;----------------------------------------
TMINCOM:CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,SIGAN
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	CALL	STARTP		;1 LINE BLANK
	;
	LD	DE,TDATA1
	LD	BC,TIMGUM
	;
	LD	A,1
	LD	(CIRNO),A
	;
TDPRLP: LD	HL,TRANBF+6
	CALL	MOVE8
	LD	HL,TRANBF+30
	CALL	CON8DIG
	CALL	STARTP
	CALL	BFCLE
	;
	INC	BC
	;
	LD	A,(CIRNO)
	INC	A
	LD	(CIRNO),A
	CP	18
	JR	NZ,TDPRLP
	;
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,4
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	;---------------------------------------
	CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,SPESAL
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	CALL	STARTP
	;------------------------------
	CALL	AFCLE		;JUNG JUN TIME COLLECTION
	LD	HL,TRANBF+4
	LD	DE,JUNGTIM
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+5
	LD	DE,JJNGCNT
	CALL	MOVE8
	LD	HL,TRANBF+22
	LD	DE,JJNGTIM
	CALL	MOVE8
	CALL	STARTP
	CALL	BFCLE
	;
	LD	BC,POWOFF
	LD	(PRBCA),BC
PRWACT: LD	A,(PRBCA)
	OR	A
	JP	Z,PRWLINE
	;
	LD	HL,TRANBF+8
	CALL	ASCVTN2
	LD	HL,TRANBF+25
	CALL	ASCVTN2
	INC	HL
	LD	(HL),':'
	INC	HL
	CALL	ASCVTT2
	INC	BC
	INC	BC
	LD	(PRBCA),BC
	;
	CALL	STARTP
	CALL	BFCLE
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	JP	NZ,PRWACT
	;
PRWLINE:LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,4
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	;-------------------------------------------------
JUNGMCO:CALL	AFCLE		;JUNG JUNG MENU COLLECTION
	LD	HL,TRANBF+4
	LD	DE,JUNGMEN
	CALL	MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,PMSUGU
	CALL	MOVE14
	;
	LD	HL,TRANBF+19
	LD	DE,JJMEN1
	CALL	MOVE18
	;
	LD	HL,TRANBF+35
	LD	DE,JJMEN2
	CALL	MOVE8
	;
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	JGMENU
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,4
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	;-------------------------
	;


NOINCOM:CALL	AFCLE		;NOT INPUT INCOME
	 LD	 HL,TRANBF+4
	 LD	 DE,NOINPUT
	 CALL	 MOVE20
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,NOPMSU
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TAB1
	LD	BC,1
	;
NINLOP: LD	A,(HL)
	INC	HL
	OR	A,(HL)
	INC	HL
	OR	A,(HL)
	INC	HL
	OR	A,(HL)
	JP	NZ,MOVDAT
	;
NNLOP:	XOR	A
	LD	A,1
	ADD	A,C
	DAA
	LD	C,A
	LD	A,0
	ADC	A,B
	DAA
	LD	B,A
	LD	A,00H
	CP	C
	JP	NZ,NNLOP1
	LD	A,1
	CP	B
	JP	Z,ONEEND
	;
NNLOP1: XOR	A
	DEC	HL
	DEC	HL
	DEC	HL
	LD	A,254
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	JP	NINLOP
	;
MOVDAT: PUSH	HL
	PUSH	BC
	LD	A,B
	LD	(JNOBF),A
	LD	A,C
	LD	(JNOBF+1),A
	;
	DEC	HL
	DEC	HL
	DEC	HL
	LD	BC,0254
	LD	DE,WORK
	LDIR
	;
	CALL	MPBCLE
	CALL	PRBCLE
	CALL	BFCLE
	LD	HL,WORK+4
	CALL	PRMOD
	CALL	YUNGA
	CALL	NOMENU
	LD	HL,WORK
	LD	DE,TEMBF
	CALL	ADD4DG
	CALL	STARTP
	POP	BC
	POP	HL
	JP	NNLOP
	;
ONEEND: LD	HL,TRANBF+3
	LD	DE,LINE
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	CALL	AFCLE
	LD	DE,TEMBF+3
	CALL	CONSUM1
	LD	A,0A3H
	LD	(TRANBF+5),A
	LD	A,0A1H
	LD	(TRANBF+6),A
	LD	A,0B7H
	LD	(TRANBF+7),A
	LD	A,0B3H
	LD	(TRANBF+8),A
	LD	A,08BH
	LD	(TRANBF+9),A
	LD	A,071H
	LD	(TRANBF+10),A
	LD	A,0B4H
	LD	(TRANBF+11),A
	LD	A,82H
	LD	(TRANBF+12),A
	;
	CALL	CONSUM3
	CALL	STARTP
	CALL	BFCLE
	;
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	CALL	PRBCLE
	CALL	MPBCLE
	JP	CLEAR
	;-----------------------------
MOVMASG:CALL	BFCLE
	LD	HL,TRANBF+3
	LD	DE,NOMASG1
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,NOMASG2
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,NOMASG3
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,TRANBF+3
	LD	DE,NOMASG1
	CALL	MOVE40
	CALL	STARTP
	CALL	BFCLE
	;
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTP
	CALL	BFCLE
	RET
	;
	;----------------------------------------------
JGMENU: LD	BC,JJDATA
	LD	(PRBCB),BC
	LD	A,0
	LD	(CIRNO),A
	LD	HL,CPDBF1
	LD	(HL),0
	INC	HL
	LD	(HL),1
	;
JGCPRA: LD	DE,HAN1
JGCPRB: LD	HL,(PRBCB)
	LD	A,(HL)
	INC	HL
	OR	(HL)
	RET	Z
	LD	HL,CPDBF1
	LD	BC,(PRBCB)
	;
	LD	A,(BC)
	CP	(HL)
	JP	NZ,JGNOT1
	INC	HL
	INC	BC
	LD	A,(BC)
	CP	(HL)
	JP	NZ,JGNOT1
	JP	JGMOV
	;
JGNOT1: XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	LD	HL,CPDBF1+1
	XOR	A
	LD	A,1
	ADD	A,(HL)
	DAA
	LD	(HL),A
	DEC	HL
	LD	A,0
	ADC	A,(HL)
	DAA
	LD	(HL),A
	;
	CP	1
	JR	NZ,JGCPRB
	INC	HL
	LD	A,(HL)
	CP	26H
	JR	NZ,JGCPRB
	RET
	;
JGMOV:	LD	HL,TRANBF+3
	CALL	MOVE14
	;
	INC	BC
	LD	HL,TRANBF+19
	CALL	ASCVTT4        ;2
	LD	HL,TRANBF+24
	LD	(HL),'-'
	INC	HL
	LD	(HL),'-'
	INC	HL
	LD	(HL),'-'
	INC	HL
	LD	(HL),'>'
	LD	HL,TRANBF+29
	CALL	ASCVTT4
	LD	HL,TRANBF+38
	CALL	ASCVTN2
	INC	HL
	LD	(HL),':'
	INC	HL
	CALL	ASCVTN2
	LD	(PRBCB),BC
	;
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,CPDBF1
	LD	(HL),0
	INC	HL
	LD	(HL),1
	;
	LD	HL,(PRBCB)
	LD	A,(HL)
	INC	HL
	OR	A,(HL)
	JP	NZ,JGCPRA
	RET
	;----------------------------------------
PRINTJ: CALL	TIMSAV
	;
	CALL	MPBCLE
	LD	HL,TEMBF+4
	CALL	PRMOD
	;
	CALL	BUABCK
	;
	LD	A,(BUAFLG)
	OR	A
	CALL	NZ,PRJACT1
	;
	LD	A,(BUBFLG)
	OR	A
	CALL	NZ,PRJACT2
	;
	LD	A,(BUCFLG)
	OR	A
	CALL	NZ,PRJACT3
	;
	RET
	;
PRJACT1:LD	A,(LAFLG)
	OR	A
	JR	NZ,CHWJUN	 ;CHWGA JUNPYO
	;
	CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,JUNPYO
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTS
	CALL	BFCLE
	JR	JUNBRD
	;
CHWJUN: CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,CHWGA
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTS
	CALL	BFCLE
	;
JUNBRD: LD	HL,TRANBF+25
	LD	DE,PRTIME
	CALL	MOVE18
	CALL	STARTS
	CALL	AFCLE
	;
	LD	HL,TRANBF+4
	LD	DE,JWASUK
	CALL	MOVE20
	LD	HL,TRANBF+15
	LD	DE,PRCHNO+1
	CALL	MOVE3
	CALL	STARTS
	CALL	AFCLE
	;
	CALL	MPBCLE
	LD	HL,TEMBF+4
	CALL	PRMOD
	CALL	JUMENU
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTS
	CALL	BFCLE
	RET
	;----------------------
PRJACT2:LD	A,(LAFLG)
	OR	A
	JR	NZ,CHWJUN2	;CHWGA JUNPYO
	;
	CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,JUNPYO
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTT
	CALL	BFCLE
	JR	JUNBRD2
	;
CHWJUN2:CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,CHWGA
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTT
	CALL	BFCLE
	;
JUNBRD2:LD	HL,TRANBF+25
	LD	DE,PRTIME
	CALL	MOVE18
	CALL	STARTT
	CALL	AFCLE
	;
	LD	HL,TRANBF+4
	LD	DE,JWASUK
	CALL	MOVE20
	LD	HL,TRANBF+15
	LD	DE,PRCHNO+1
	CALL	MOVE3
	CALL	STARTT
	CALL	AFCLE
	;
	CALL	MPBCLE
	LD	HL,TEMBF+4
	CALL	PRMOD
	CALL	JUMENU2
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTT
	CALL	BFCLE
	RET
	;----------------------
PRJACT3:LD	A,(LAFLG)
	OR	A
	JR	NZ,CHWJUN3	;CHWGA JUNPYO
	;
	CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,JUNPYO
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTU
	CALL	BFCLE
	JR	JUNBRD3
	;
CHWJUN3:CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,CHWGA
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTU
	CALL	BFCLE
	;
JUNBRD3:LD	HL,TRANBF+25
	LD	DE,PRTIME
	CALL	MOVE18
	CALL	STARTU
	CALL	AFCLE
	;
	LD	HL,TRANBF+4
	LD	DE,JWASUK
	CALL	MOVE20
	LD	HL,TRANBF+15
	LD	DE,PRCHNO+1
	CALL	MOVE3
	CALL	STARTU
	CALL	AFCLE
	;
	CALL	MPBCLE
	LD	HL,TEMBF+4
	CALL	PRMOD
	CALL	JUMENU3
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTU
	CALL	BFCLE
	RET
	;----------------------
BUABCK: LD	BC,125
	LD	DE,MPB
BUAKLP: LD	HL,RSM0
	XOR	A
	LD	A,(DE)
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	LD	A,(HL)
	CP	1
	JR	Z,BUAK1
	CP	2
	JR	Z,BUAK2
	CP	3
	JR	Z,BUAK3
	;
RETBUK: INC	DE
	INC	DE
	INC	DE
	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,BUAKLP
	RET
	;
BUAK1:	LD	A,0FH
	LD	(BUAFLG),A
	JR	RETBUK
	;
BUAK2:	LD	A,0FH
	LD	(BUBFLG),A
	JR	RETBUK
	;
BUAK3:	LD	A,0FH
	LD	(BUCFLG),A
	JR	RETBUK
	;----------------------------------------------
JUMENU: LD	BC,MPB
	LD	(PRBCA),BC
	LD	A,0
	LD	(CIRNO),A
	LD	HL,CPDBF
	LD	(HL),1
	;
JUCPRA: LD	DE,HAN1
JUCPRB: LD	HL,CPDBF
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	RET	Z
	;
	CPD
	JP	Z,JUMOV
	;
	XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	INC	HL
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	JR	JUCPRB
	;
JUMOV:	INC	BC
	LD	HL,RSM0
	XOR	A
	LD	A,(BC)
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	LD	A,(HL)
	CP	1
	JR	Z,ASRS1
	INC	BC
	INC	BC
	INC	BC
	LD	(PRBCA),BC
	JR	BSRS1
	;
ASRS1:	LD	HL,TRANBF+4
	;
	CALL	MOVE14
	LD	HL,TRANBF+20
	CALL	ASCVT4
	;
	CALL	STARTS
	CALL	AFCLE
	;
BSRS1:	LD	HL,CIRNO
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	LD	HL,CPDBF
	LD	(HL),1
	JP	JUCPRA
	;----------------------------------------------
JUMENU2:LD	BC,MPB
	LD	(PRBCA),BC
	LD	A,0
	LD	(CIRNO),A
	LD	HL,CPDBF
	LD	(HL),1
	;
JUCPRA2:LD	DE,HAN1
JUCPRB2:LD	HL,CPDBF
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	RET	Z
	;
	CPD
	JP	Z,JUMOV2
	;
	XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	INC	HL
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	JR	JUCPRB2
	;
JUMOV2: INC	BC
	LD	HL,RSM0
	XOR	A
	LD	A,(BC)
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	LD	A,(HL)
	CP	2
	JR	Z,ASRS2
	INC	BC
	INC	BC
	INC	BC
	LD	(PRBCA),BC
	JR	BSRS2
	;
ASRS2:	LD	HL,TRANBF+4
	;
	CALL	MOVE14
	LD	HL,TRANBF+20
	CALL	ASCVT4
	;
	CALL	STARTT
	CALL	AFCLE
	;
BSRS2:	LD	HL,CIRNO
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	LD	HL,CPDBF
	LD	(HL),1
	JP	JUCPRA2
	;
JUMENU3:LD	BC,MPB
	LD	(PRBCA),BC
	LD	A,0
	LD	(CIRNO),A
	LD	HL,CPDBF
	LD	(HL),1
	;
JUCPRA3:LD	DE,HAN1
JUCPRB3:LD	HL,CPDBF
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	RET	Z
	;
	CPD
	JP	Z,JUMOV3
	;
	XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	INC	HL
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	JR	JUCPRB3
	;
JUMOV3: INC	BC
	LD	HL,RSM0
	XOR	A
	LD	A,(BC)
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	LD	A,(HL)
	CP	3
	JR	Z,ASRS3
	INC	BC
	INC	BC
	INC	BC
	LD	(PRBCA),BC
	JR	BSRS3
	;
ASRS3:	LD	HL,TRANBF+4
	;
	CALL	MOVE14
	LD	HL,TRANBF+20
	CALL	ASCVT4
	;
	CALL	STARTU
	CALL	AFCLE
	;
BSRS3:	LD	HL,CIRNO
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	LD	HL,CPDBF
	LD	(HL),1
	JP	JUCPRA3
	;----------------------------------------------
JRMENU: LD	BC,MPB1
	LD	(PRBCB),BC
	LD	BC,MPB
	LD	(PRBCA),BC
	LD	A,0
	LD	(CIRNO),A
	LD	HL,CPDBF
	LD	(HL),1
	;
JRCPRA: LD	DE,HAN1
JRCPRB: LD	HL,CPDBF
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	RET	Z
	;
	CPD
	JP	Z,JRMOV
	;
	XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	INC	HL
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	JR	JRCPRB
	;
JRMOV:	INC	BC
	LD	HL,RSM0
	XOR	A
	LD	A,(BC)
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	LD	A,(HL)
	CP	1
	JR	Z,JARS1
	INC	BC
	INC	BC
	INC	BC
	LD	(PRBCA),BC
	LD	BC,(PRBCB)
	INC	BC
	LD	(PRBCB),BC
	JR	JBRS1
	;
JARS1:	LD	HL,TRANBF+4
	;
	CALL	MOVE14
	INC	BC
	INC	BC
	LD	HL,TRANBF+18
	CALL	ASCVTN2
	LD	HL,TRANBF+20
	LD	(HL),'-'
	INC	HL
	LD	(HL),'>'
	INC	BC
	;
	PUSH	BC
	LD	BC,(PRBCB)
	;
	LD	HL,TRANBF+22
	CALL	ASCVTR2
	POP	BC
	CALL	STARTS
	CALL	AFCLE
	;
JBRS1:	LD	HL,CIRNO
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	LD	HL,CPDBF
	LD	(HL),1
	JP	JRCPRA
	;----------------------------------------------
JRMENU2:LD	BC,MPB1
	LD	(PRBCB),BC
	LD	BC,MPB
	LD	(PRBCA),BC
	LD	A,0
	LD	(CIRNO),A
	LD	HL,CPDBF
	LD	(HL),1
	;
JRCPRA2:LD	DE,HAN1
JRCPRB2:LD	HL,CPDBF
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	RET	Z
	;
	CPD
	JP	Z,JRMOV2
	;
	XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	INC	HL
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	JR	JRCPRB2
	;
JRMOV2: INC	BC
	LD	HL,RSM0
	XOR	A
	LD	A,(BC)
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	LD	A,(HL)
	CP	2
	JR	Z,JARS2
	INC	BC
	INC	BC
	INC	BC
	LD	(PRBCA),BC
	LD	BC,(PRBCB)
	INC	BC
	LD	(PRBCB),BC
	JR	JBRS2
	;
JARS2:	LD	HL,TRANBF+4
	;
	CALL	MOVE14
	INC	BC
	INC	BC
	LD	HL,TRANBF+18
	CALL	ASCVTN2
	LD	HL,TRANBF+20
	LD	(HL),'-'
	INC	HL
	LD	(HL),'>'
	INC	BC
	;
	PUSH	BC
	LD	BC,(PRBCB)
	;
	LD	HL,TRANBF+22
	CALL	ASCVTR2
	POP	BC
	CALL	STARTT
	CALL	AFCLE
	;
JBRS2:	LD	HL,CIRNO
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	LD	HL,CPDBF
	LD	(HL),1
	JP	JRCPRA2
	;
JRMENU3:LD	BC,MPB1
	LD	(PRBCB),BC
	LD	BC,MPB
	LD	(PRBCA),BC
	LD	A,0
	LD	(CIRNO),A
	LD	HL,CPDBF
	LD	(HL),1
	;
JRCPRA3:LD	DE,HAN1
JRCPRB3:LD	HL,CPDBF
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	RET	Z
	;
	CPD
	JP	Z,JRMOV3
	;
	XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	INC	HL
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	JR	JRCPRB3
	;
JRMOV3: INC	BC
	LD	HL,RSM0
	XOR	A
	LD	A,(BC)
	ADD	A,L
	LD	L,A
	LD	A,0
	ADC	A,H
	LD	H,A
	;
	LD	A,(HL)
	CP	3
	JR	Z,JARS3
	INC	BC
	INC	BC
	INC	BC
	LD	(PRBCA),BC
	LD	BC,(PRBCB)
	INC	BC
	LD	(PRBCB),BC
	JR	JBRS3
	;
JARS3:	LD	HL,TRANBF+4
	;
	CALL	MOVE14
	INC	BC
	INC	BC
	LD	HL,TRANBF+18
	CALL	ASCVTN2
	LD	HL,TRANBF+20
	LD	(HL),'-'
	INC	HL
	LD	(HL),'>'
	INC	BC
	;
	PUSH	BC
	LD	BC,(PRBCB)
	;
	LD	HL,TRANBF+22
	CALL	ASCVTR2
	POP	BC
	CALL	STARTU
	CALL	AFCLE
	;
JBRS3:	LD	HL,CIRNO
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	LD	HL,CPDBF
	LD	(HL),1
	JP	JRCPRA3
	;----------------------------------------------
JJPRINT:CALL	AFCLE
	CALL	TIMSAV
	;
	CALL	MPBCLE
	LD	HL,WORK+4
	CALL	PRMOD
	;
	CALL	BUABCK
	;
	LD	A,(BUAFLG)
	OR	A
	CALL	NZ,JJUCT1
	;
	LD	A,(BUBFLG)
	OR	A
	CALL	NZ,JJUCT2
	;
	LD	A,(BUCFLG)
	OR	A
	CALL	NZ,JJUCT3
	;
	RET
	;
JJUCT1: LD	HL,TRANBF+4
	LD	DE,JUNGJUN
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTS
	CALL	BFCLE
	;
	LD	HL,TRANBF+25
	LD	DE,PRTIME
	CALL	MOVE18
	CALL	STARTS
	CALL	AFCLE
	;
	LD	HL,TRANBF+4
	LD	DE,JWASUK
	CALL	MOVE20
	LD	HL,TRANBF+15
	LD	DE,PRCHNO+1
	CALL	MOVE3
	CALL	STARTS
	CALL	AFCLE
	;
	CALL	MPBCLE
	LD	HL,WORK+4
	CALL	PRMOD1
	CALL	JRMENU
	CALL	AFCLE
	;
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTS
	CALL	BFCLE
	RET
	;----------------------------------------------
JJUCT2: CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,JUNGJUN
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTT
	CALL	BFCLE
	;
	LD	HL,TRANBF+25
	LD	DE,PRTIME
	CALL	MOVE18
	CALL	STARTT
	CALL	AFCLE
	;
	LD	HL,TRANBF+4
	LD	DE,JWASUK
	CALL	MOVE20
	LD	HL,TRANBF+15
	LD	DE,PRCHNO+1
	CALL	MOVE3
	CALL	STARTT
	CALL	AFCLE
	;
	CALL	MPBCLE
	LD	HL,WORK+4
	CALL	PRMOD1
	CALL	JRMENU2
	CALL	AFCLE
	;
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTT
	CALL	BFCLE
	RET
	;
JJUCT3: CALL	AFCLE
	LD	HL,TRANBF+4
	LD	DE,JUNGJUN
	CALL	MOVE20
	LD	HL,TRANBF+18
	LD	DE,PRJUN+1
	CALL	MOVE3
	CALL	STARTU
	CALL	BFCLE
	;
	LD	HL,TRANBF+25
	LD	DE,PRTIME
	CALL	MOVE18
	CALL	STARTU
	CALL	AFCLE
	;
	LD	HL,TRANBF+4
	LD	DE,JWASUK
	CALL	MOVE20
	LD	HL,TRANBF+15
	LD	DE,PRCHNO+1
	CALL	MOVE3
	CALL	STARTU
	CALL	AFCLE
	;
	CALL	MPBCLE
	LD	HL,WORK+4
	CALL	PRMOD1
	CALL	JRMENU3
	CALL	AFCLE
	;
	LD	A,0CH
	LD	(TRANBF),A
	LD	A,7
	LD	(TRANBF+1),A
	LD	A,2
	LD	(TBYTE),A
	LD	A,0
	LD	(TBYTE+1),A
	CALL	STARTU
	CALL	BFCLE
	RET
	;----------------------------------------------
MPBCLE: PUSH	HL
	PUSH	BC
	LD	HL,MPB
	LD	BC,0750 	;375 * 2 MPB MPB1
MLOOP4: XOR	A
	LD	(HL),A
	INC	HL
	DEC	BC
	LD	A,C
	OR	B
	JR	NZ,MLOOP4
	POP	BC
	POP	HL
	RET
	;
PRMOD:	LD	BC,MPB
	LD	A,1
	LD	D,A
NLOOP:	LD	A,(HL)
	LD	E,A
	INC	HL
	LD	A,(HL)
	OR	E
	JR	NZ,NBCC
	INC	HL
	;
	LD	A,1
	ADD	A,D
	LD	D,A
	SUB	126
	RET	NC
	JR	NLOOP
	;
NBCC:	INC	BC
	LD	A,(HL)
	LD	(BC),A
	DEC	HL
	INC	BC
	LD	A,(HL)
	LD	(BC),A
	DEC	BC
	DEC	BC
	LD	A,D
	LD	(BC),A
	INC	BC
	INC	BC
	INC	BC
	INC	HL
	INC	HL
	LD	A,1
	ADD	A,D
	LD	D,A
	SUB	126
	RET	NC		;PRINT START MOD2
	JR	NLOOP
	;
PRMOD1: LD	BC,MPB
	LD	IX,TEMBF+4
	LD	IY,MPB1
	LD	A,1
	LD	D,A
NLOOP1: LD	A,(HL)
	LD	E,A
	INC	HL
	LD	A,(HL)
	OR	E
	JR	NZ,NBCC1
	INC	HL
	;
	INC	IX
	INC	IX
	;
	LD	A,1
	ADD	A,D
	LD	D,A
	SUB	126
	RET	NC
	JR	NLOOP1
	;
NBCC1:	INC	BC
	LD	A,(HL)
	LD	(BC),A
	DEC	HL
	INC	BC
	LD	A,(HL)
	LD	(BC),A
	DEC	BC
	DEC	BC
	LD	A,D
	LD	(BC),A
	INC	BC
	INC	BC
	INC	BC
	INC	HL
	INC	HL
	LD	A,(IX)
	LD	(IY),A
	INC	IX
	INC	IX
	INC	IY
	LD	A,1
	ADD	A,D
	LD	D,A
	SUB	126
	RET	NC		;PRINT START MOD2
	JR	NLOOP1
	;
YUMENU: LD	BC,PRYUNG
	LD	(PRBCB),BC
	LD	BC,MPB
	LD	(PRBCA),BC
	LD	A,0
	LD	(CIRNO),A
	;
YUCPRA: LD	DE,HAN1
YUCPRB: LD	HL,CPDBF
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	RET	Z
	;
	CPD
	JP	Z,YUMOV
	;
	XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	INC	HL
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	JR	YUCPRB
	;
YUMOV:	LD	HL,TRANBF+3
	;
	CALL	MOVE14
	INC	BC
	LD	HL,TRANBF+25
	CALL	ASCVT4
	;
	INC	BC
	LD	HL,TRANBF+35
	CALL	ASKCVT8
	;
	INC	BC
	LD	(PRBCB),BC
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,CIRNO
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	LD	HL,CPDBF
	LD	(HL),1
	JP	YUCPRA
	;
ACTJUN: CALL	MOVE14
	INC	BC
	LD	HL,TRANBF+25
	LD	A,(BC)
	CALL	STARTS
	CALL	BFCLE
	POP	AF
	POP	BC
	;
	;---------------------------
NOMENU: LD	BC,JNOBF
	LD	HL,TRANBF+3
	LD	(HL),0EH
	CALL	ASCVT3
	INC	HL
	LD	(HL),0FH
	LD	A,42
	LD	(TBYTE),A
	;
	LD	BC,PRYUNG
	LD	(PRBCB),BC
	LD	BC,MPB
	LD	(PRBCA),BC
	LD	A,0
	LD	(CIRNO),A
	;
NOCPRA: LD	DE,HAN1
NOCPRB: LD	HL,CPDBF
	LD	BC,(PRBCA)
	LD	A,(BC)
	OR	A
	RET	Z
	;
	CPD
	JP	Z,NOMOV
	;
	XOR	A
	LD	A,14
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	;
	INC	HL
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	JR	NOCPRB
	;
NOMOV:	LD	HL,TRANBF+3
	LD	A,(HL)
	CP	0EH
	JR	NZ,NOMOV1
	;
	LD	HL,TRANBF+11
	;
	CALL	MOVE14
	INC	BC
	LD	HL,TRANBF+27
	CALL	ASCVT4
	;
	INC	BC
	LD	HL,TRANBF+34
NOMOV2: CALL	ASKCVT8
	;
	INC	BC
	LD	(PRBCB),BC
	CALL	STARTP
	CALL	BFCLE
	;
	LD	HL,CIRNO
	INC	(HL)
	LD	A,(HL)
	CP	126
	RET	Z
	LD	HL,CPDBF
	LD	(HL),1
	JP	NOCPRA
	;---------------------------------------
NOMOV1: LD	HL,TRANBF+12
	;
	CALL	MOVE14
	INC	BC
	LD	HL,TRANBF+28
	CALL	ASCVT4
	;
	INC	BC
	LD	HL,TRANBF+35
	JP	NOMOV2
	;---------------------------------------
	;
MOVBNK: LD	HL,TRANBF+3
	LD	B,10
MOBLP:	LD	(HL),20H
	INC	HL
	DJNZ	MOBLP
	RET
	;
MOVE40: PUSH	BC
	LD	B,40
	JR	MOVLP8
	;
MOVE20: PUSH	BC
	LD	B,20
	JR	MOVLP8
	;
MOVE22: PUSH	BC
	LD	B,22
	JR	MOVLP8
	;
MOVE18: PUSH	BC
	LD	B,18
	JR	MOVLP8
	;
MOVE14: PUSH	BC
	LD	B,14
	JR	MOVLP8
	;
MOVE10: PUSH	BC
	LD	B,10
	JR	MOVLP8
	;
MOVE8:	PUSH	BC
	LD	B,8
	JR	MOVLP8
	;
MOVLP8: LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	MOVLP8
	POP	BC
	RET
	;
MOVE3:	LD	B,3
MOV3LP: LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	MOV3LP
	RET
	;
TIMSAV: LD	HL,PRTIME
	LD	B,18
CLRPRT: LD	(HL),20H
	INC	HL
	DJNZ	CLRPRT
	;
	LD	BC,DATE+2
	LD	HL,PRTIME
	CALL	ASCVTT2
	LD	(HL),'/'
	INC	HL
	CALL	ASCVTT2
	LD	(HL),'/'
	INC	HL
	CALL	ASCVTT2
	INC	HL
	INC	HL
	INC	HL
	LD	(HL),'T'
	INC	HL
	INC	HL
	LD	BC,DTIME+1
	CALL	ASCVTT2
	LD	(HL),':'
	INC	HL
	CALL	ASCVTT2
	;
	RET
	;
	;
ASCVTT2:LD	A,(BC)		;(BC)=DECIMAL
	AND	0F0H		;(HL)=ASC II
	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	;
	INC	HL
	LD	A,(BC)
	AND	0FH
	OR	A,30H
	LD	(HL),A
	INC	HL
	DEC	BC
	RET
	;
	;
ASCVT4: INC	BC
ASCVTT4:LD	A,(BC)
	AND	0F0H
	JR	Z,ASCVT3
	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	INC	HL
	LD	A,(BC)
	AND	0FH
	JR	ACVT3
	;
ASCVT3: INC	HL
	LD	A,(BC)
	AND	0FH
	JR	Z,ASCVT2
	;
ACVT3:	OR	A,30H
	LD	(HL),A
	INC	HL
	INC	BC
	LD	A,(BC)
	AND	0F0H
	JR	ACVT2
	;
ASCVT2: INC	HL
	INC	BC
ASCVTN2:LD	A,(BC)
	AND	0F0H
	JR	Z,ASCVT1
ACVT2	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	;
ASCVT1: INC	HL
	LD	A,(BC)
	AND	0FH
	OR	A,30H
	LD	(HL),A
	;
	INC	BC
	LD	(PRBCA),BC
	RET
	;
ASCVTR2:LD	A,(BC)
	AND	0F0H
	JR	Z,ASCVR1
ACVR2	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	;
ASCVR1: INC	HL
	LD	A,(BC)
	AND	0FH
	OR	A,30H
	LD	(HL),A
	INC	BC
	LD	(PRBCB),BC
	RET
	;
ASKCVT8:LD	BC,(PRBCB)
CON8DIG:LD	A,(BC)
	AND	0F0H
	JR	Z,ASKCVT7
	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	INC	HL
	LD	A,(BC)
	AND	0FH
	JR	AKT7
	;
ASKCVT7:INC	HL
	LD	A,(BC)
	AND	0FH
	JR	Z,ASKCVT6
	;
AKT7:	OR	A,30H
	LD	(HL),A
	INC	HL
	INC	BC
	LD	A,(BC)
	AND	0F0H
	JR	AKT6
	;
ASKCVT6:INC	HL
	INC	BC
	LD	A,(BC)
	AND	0F0H
	JR	Z,ASKCVT5
AKT6:	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	INC	HL
	LD	A,(BC)
	AND	0FH
	JR	AKT5
	;
ASKCVT5:INC	HL
	LD	A,(BC)
	AND	0FH
	JR	Z,ASKCVT4
	;
AKT5:	OR	A,30H
	LD	(HL),A
	INC	HL
	INC	BC
	LD	A,(BC)
	AND	0F0H
	JR	AKT4
	;
ASKCVT4:INC	HL
	INC	BC
	LD	A,(BC)
	AND	0F0H
	JR	Z,ASKCVT3
AKT4:	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	INC	HL
	LD	A,(BC)
	AND	0FH
	JR	AKT3
	;
ASKCVT3:INC	HL
	LD	A,(BC)
	AND	0FH
	JR	Z,ASKCVT2
	;
AKT3:	OR	A,30H
	LD	(HL),A
	INC	HL
	INC	BC
	LD	A,(BC)
	AND	0F0H
	JR	AKT2
	;
ASKCVT2:INC	HL
	INC	BC
	LD	A,(BC)
	AND	0F0H
	JR	Z,ASKCVT1
AKT2:	RRA
	RRA
	RRA
	RRA
	OR	A,30H
	LD	(HL),A
	;
ASKCVT1:INC	HL
	LD	A,(BC)
	AND	0FH
	OR	A,30H
	LD	(HL),A
	RET

	;////// DATA SEGMENT AREA \\\\\\
PASS:   DB      34H,49H
        ;
KEISAN: DB      20H,20H,2AH,2AH,2AH,20H,0B5H,77H,20H
        DB      0AEH,81H,20H,0BBH,77H,20H,2AH,2AH,2AH,20H,20H
        ;
LINE:   DB      2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH
        DB      2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH
        DB      2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH
        DB      2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH,2DH
        ;
FIRM:   DB      89H,0B1H,8AH,82H,0AFH,0A1H,0BBH,0B3H,20H,20H
        DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
ADDRESS:DB      0ACH,0E1H,0B6H,89H,0AFH,0A1H,20H,0BAH,97H,8AH
        DB      81H,20H,0B7H,69H,0BBH,0A1H,9DH,0A1H,32H,88H
        DB      61H,20H,31H,39H,39H,2DH,37H,34H,20H,20H
        DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
NAME:   DB      31H,30H,34H,2DH,30H,35H,2DH,33H,35H,36H
        DB      33H,36H,20H,20H,20H,20H,20H,20H,20H,20H
        DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        DB      0B7H,41H,0ACH,71H,0AEH,85H,20H,20H,20H,20H
        ;
TELNO:  DB      'T','E','L',20H,37H,35H,36H,'-',33H,34H
        DB      34H,39H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
PMSUGU: DB 0CEH,91H,20H,20H,20H,20H,20H,20H,20H,20H
       DB  20H,20H,0A1H,77H,20H,20H,20H,20H,20H,20H
       DB  20H,20H,0AEH,81H,20H,9CH,0B7H,20H,20H,20H
       DB  20H,20H,20H,8BH,71H,20H,20H,20H,0B4H,82H
       ;
JEJE:  DB  0B8H,0F7H,0ACH,65H,0D2H,55H,0AEH,81H,20H
       DB  ':',20H,20H,20H,20H,20H,20H,20H,20H
      ;
JUNPYO: DB 2AH,20H,0BAH,81H,0A2H,85H,0B8H,0E5H,0CEH
       DB  61H,20H,2AH,2AH,20H,20H,20H,20H,20H,2AH,2AH
       ;
CHWGA: DB  2AH,20H,0C2H,81H,088H,61H,0B8H,0E5H,0CEH
       DB  61H,20H,2AH,2AH,20H,20H,20H,20H,20H,2AH,2AH
       ;
CHWISO: DB 2AH,20H,0C2H,0E1H,0ADH,0A1H,0B8H,0E5H,0CEH
       DB  61H,20H,2AH,2AH,20H,20H,20H,20H,20H,2AH,2AH
       ;
JUNGJUN:DB 2AH,20H,0B8H,0F7H,0B8H,0F7H,0B8H,0E5H,0CEH
       DB  61H,20H,2AH,2AH,20H,20H,20H,20H,20H,2AH,2AH
       ;
JWASUK: DB 2DH,2DH,2DH,2DH,2DH,20H,0B9H,0C1H,0ACH,0E2H,':'
       DB  20H,20H,20H,20H,2DH,2DH,2DH,2DH,2DH
       ;
KYULSAN:DB 2AH,2AH,20H,0B7H,0A9H,0B7H,0A9H,0B5H,77H,0B4H,0F3H
       DB  89H,69H,0ACH,65H,0ACH,0E1H,20H,2AH,2AH
       ;
TONGHAB:DB 20H,20H,20H,02AH,02AH,020H,0C9H,0B7H,0D0H,073H,0B8H
       DB  0F7H,0ACH,065H,20H,02AH,02AH,20H,20H,20H
       ;
HYUNGUM:DB 20H,20H,20H,02AH,02AH,020H,0D1H,065H,08BH,071H,0B8H
       DB  0F7H,0ACH,065H,20H,02AH,02AH,20H,20H,20H
       ;
SHINYNG:DB 20H,20H,20H,02AH,02AH,020H,0AFH,0A5H,0B6H,077H,0B8H
       DB  0F7H,0ACH,065H,20H,02AH,02AH,20H,20H,20H
       ;
OISANG: DB 20H,20H,20H,02AH,02AH,020H,0B6H,041H,0ACH,077H,0B8H
       DB  0F7H,0ACH,065H,20H,02AH,02AH,20H,20H,20H
       ;
SIGAN: DB  2AH,20H,0AFH,0A1H,88H,65H,94H,81H,0A5H,69H,0CCH,65H
       DB  0A0H,81H,8BH,71H,0B4H,82H,20H,2AH
       ;
NOPMSU: DB 020H,0B9H,0C1H,20H,0ACH,0E2H,20H,20H,20H
       DB  0CEH,91H,20H,20H,20H,20H,020H,20H,0A1H,77H
       DB  20H,20H,20H,20H,20H,20H,0AEH,81H,20H,9CH,0B7H
       DB  20H,20H,20H,20H,8BH,71H,20H,20H,0B4H,82H
       ;
NOMASG1:DB 7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH
       DB  7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH
       DB  7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH
       DB  7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH,7FH
       ;
NOMASG2:DB 7FH,7FH,20H,20H,20H,0A3H,0A1H,20H,0B7H,0B3H,8BH,71H
       DB  96H,45H,20H,0B9H,0C1H,0ACH,0E2H,0B7H,0A1H,20H,0B7H
       DB  0B6H,0B7H,073H,93H,0A1H,94H,61H,20H,20H,21H,21H,21H
       DB  20H,20H,20H,7FH,7FH
       ;
NOMASG3:DB 7FH,7FH,20H,20H,20H,0B7H,0B3H,8BH,071H,0B5H,0C5H
       DB  9EH,61H,0D2H,81H,20H,0B7H,0A9H,0B7H,0A9H,0B8H,0F7H
       DB  0ACH,065H,20H,0A4H,61H,9CH,73H,93H,0A1H,94H,61H
       DB  20H,2EH,2EH,2EH,20H,7FH,7FH
       ;
       ;*********************************
       ;TIME OF TOTAL INCOME
TDATA1: DB 20H,37H,20H,2DH,2DH,20H,20H,38H
TDATA2: DB 20H,38H,20H,2DH,2DH,20H,20H,39H
TDATA3: DB 20H,39H,20H,2DH,2DH,20H,31H,30H
TDATA4: DB 31H,30H,20H,2DH,2DH,20H,31H,31H
TDATA5: DB 31H,31H,20H,2DH,2DH,20H,31H,32H
TDATA6: DB 31H,32H,20H,2DH,2DH,20H,31H,33H
TDATA7: DB 31H,33H,20H,2DH,2DH,20H,31H,34H
TDATA8: DB 31H,34H,20H,2DH,2DH,20H,31H,35H
TDATA9: DB 31H,35H,20H,2DH,2DH,20H,31H,36H
TDATA10 DB 31H,36H,20H,2DH,2DH,20H,31H,37H
TDATA11:DB 31H,37H,20H,2DH,2DH,20H,31H,38H
TDATA12:DB 31H,38H,20H,2DH,2DH,20H,31H,39H
TDATA13:DB 31H,39H,20H,2DH,2DH,20H,32H,30H
TDATA14:DB 32H,30H,20H,2DH,2DH,20H,32H,31H
TDATA15:DB 32H,31H,20H,2DH,2DH,20H,32H,32H
TDATA16:DB 32H,32H,20H,2DH,2DH,20H,32H,33H
TDATA17:DB 32H,33H,20H,2DH,2DH,20H,32H,34H
       ;
SPESAL: DB 20H,20H,'<','<',0CBH,62H,0A5H,69H,89H,0C5H
       DB  9FH,0A1H,0B8H,61H,9EH,61H,'>','>',20H,20H
       ;
JUNGTIM:DB 31H,'.',0B8H,0F7H,0B8H,0E5H,0AFH,0A1H,88H,65H
       DB  0BBH,0B3H,89H,81H,20H,20H,20H,20H,20H,20H
       ;
JUNGMEN:DB 32H,'.',0B8H,0F7H,0B8H,0F7H,0A1H,41H,93H,41H
       DB  0BBH,0B3H,89H,81H,20H,20H,20H,20H,20H,20H
       ;
NOINPUT:DB 33H,'.',0A3H,0A1H,0B7H,0B3H,8BH,71H,0ACH,77H
       DB  0D1H,0D7H,20H,20H,20H,20H,20H,20H,20H,20H
       ;
JJNGCNT:DB 0B8H,0F7H,0B8H,0E5H,0D2H,55H,0AEH,81H
       ;
JJNGTIM:DB 0B8H,0F7H,0B8H,0E5H,0AFH,0A1H,88H,65H
       ;
JJMEN1: DB 0BAH,81H,0A2H,85H,0AEH,81H,20H,20H,20H,20H
       DB  0B8H,0F7H,0B8H,0F7H,0AEH,81H,20H,20H,20H
       ;
JJMEN2: DB 20H,20H,20H,0AFH,0A1H,20H,88H,65H
       ;
       DB  20H,20H
       ;
       ;///// HANGUL MENU DATA AREA \\\\\
HAN1:   DB      89H,0B1H,8AH,82H,0AEH,81H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN2:   DB      0B6H,81H,9DH,0B7H,0C0H,61H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN3:   DB      0ACH,97H,0AEH,81H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN4:   DB      0A0H,62H,88H,0E9H,9FH,0A1H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN5:   DB      0BBH,41H,0AFH,61H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN6:   DB      4DH,45H,44H,4FH,43H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN7:   DB      0A0H,61H,0BAH,81H,0B4H,77H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN8:   DB      0ADH,0A1H,0BAH,81H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN9:   DB      0A0H,82H,0BAH,81H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN10:  DB      0C0H,0F7H,0D0H,61H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN11:  DB      0A4H,82H,0ADH,41H,0BAH,81H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN12:  DB      0B4H,65H,95H,0B7H,0ADH,0A1H,0BAH,81H,32H,31H,25H,20H,20H,20H
        ;
HAN13:  DB      0ACH,65H,0ACH,61H,0A0H,81H,0C2H,0E1H,0ACH,0E9H,0BAH,97H,0A0H,81H
        ;
HAN14:  DB      0B4H,0B7H,0BAH,81H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN15:  DB      0B6H,81H,0ACH,0E9H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN16:  DB      0B7H,42H,0D2H,41H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN17:  DB      0A6H,89H,89H,0A1H,8BH,0A1H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN18:  DB      0B5H,0A1H,89H,73H,0ACH,69H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN19:  DB      88H,65H,0B8H,77H,89H,41H,0B8H,77H,20H,20H,20H,20H,20H,20H
        ;
HAN20:  DB      0A8H,69H,88H,65H,89H,41H,0B8H,77H,20H,20H,20H,20H,20H,20H
        ;
HAN21:  DB      0A5H,0B7H,0ACH,61H,9EH,61H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN22:  DB      0ACH,97H,97H,77H,0AFH,0B1H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN23:  DB      88H,69H,0A7H,0A1H,0ACH,69H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN24:  DB      0ACH,81H,0B5H,0D7H,88H,69H,0A7H,0A1H,20H,20H,20H,20H,20H,20H
        ;
HAN25:  DB      0B4H,0B7H,91H,71H,88H,69H,0A7H,0A1H,20H,20H,20H,20H,20H,20H
        ;
HAN26:  DB      8DH,0B9H,97H,77H,0AFH,0B1H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN27:  DB      0C0H,61H,95H,0A9H,0A4H,62H,0B7H,0A1H,20H,20H,20H,20H,20H,20H
        ;
HAN28:  DB      0B4H,65H,0AFH,0B1H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN29:  DB      89H,0B7H,8BH,0A1H,0A4H,73H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN30:  DB      0A0H,65H,96H,81H,0ACH,61H,9FH,0A1H,20H,20H,20H,20H,20H,20H
        ;
HAN31:  DB      0ACH,0A1H,0A7H,61H,89H,0A1H,8BH,0A1H,20H,20H,20H,20H,20H,20H
        ;
HAN32:  DB      0AEH,81H,0B7H,42H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN33:  DB      0A7H,0A1H,0A7H,0B1H,0A4H,73H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN34:  DB      95H,0A9H,0ADH,0BBH,0A7H,0A1H,0A7H,0B1H,0A4H,73H,20H,20H,20H,20H
        ;
HAN35:  DB      88H,69H,0A7H,0A1H,0C8H,77H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN36:  DB      89H,0B1H,8AH,82H,0AEH,81H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN37:  DB      0B8H,0E5H,89H,0A9H,8AH,82H,0AEH,81H,20H,20H,20H,20H,20H,20H
        ;
HAN38:  DB      0A0H,65H,96H,81H,0B8H,0E5H,89H,0A9H,20H,20H,20H,20H,20H,20H
        ;
HAN39:  DB      0A2H,89H,90H,97H,0A1H,65H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN40:  DB      0A7H,0A1H,0A7H,0B1H,90H,97H,0A1H,65H,20H,20H,20H,20H,20H,20H
        ;
HAN41:  DB      90H,97H,0A1H,65H,0ACH,61H,9FH,0A1H,20H,20H,20H,20H,20H,20H
        ;
HAN42:  DB      8BH,0A1H,0C8H,61H,0A1H,41H,93H,41H,20H,20H,20H,20H,20H,20H
        ;
HAN43:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN44:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN45:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN46:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN47:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN48:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN49:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN50:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN51:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN52:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN53:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN54:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN55:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN56:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN57:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN58:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN59:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN60:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN61:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN62:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN63:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN64:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN65:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN66:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN67:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN68:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN69:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN70:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN71:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN72:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN73:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN74:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN75:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN76:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN77:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN78:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN79:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN80:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN81:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN82:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN83:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN84:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN85:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN86:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN87:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN88:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN89:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN90:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN91:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN92:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN93:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN94:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN95:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN96:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN97:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN98:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN99:  DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN100: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN101: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN102: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN103: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN104: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN105: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN106: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN107: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN108: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN109: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN110: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN111: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN112: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN113: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN114: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN115: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN116: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN117: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN118: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN119: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN120: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN121: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN122: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN123: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN124: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN125: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
HAN126: DB      20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H,20H
        ;
RSM0:   DB      0
RSM1:   DB      01H
RSM2:   DB      01H
RSM3:   DB      01H
RSM4:   DB      01H
RSM5:   DB      01H
RSM6:   DB      01H
RSM7:   DB      01H
RSM8:   DB      01H
RSM9:   DB      01H
RSM10:  DB      01H
RSM11:  DB      01H
RSM12:  DB      01H
RSM13:  DB      01H
RSM14:  DB      01H
RSM15:  DB      01H
RSM16:  DB      01H
RSM17:  DB      01H
RSM18:  DB      01H
RSM19:  DB      01H
RSM20:  DB      01H
RSM21:  DB      01H
RSM22:  DB      01H
RSM23:  DB      01H
RSM24:  DB      01H
RSM25:  DB      01H
RSM26:  DB      01H
RSM27:  DB      01H
RSM28:  DB      01H
RSM29:  DB      01H
RSM30:  DB      01H
RSM31:  DB      01H
RSM32:  DB      01H
RSM33:  DB      01H
RSM34:  DB      01H
RSM35:  DB      01H
RSM36:  DB      01H
RSM37:  DB      01H
RSM38:  DB      01H
RSM39:  DB      01H
RSM40:  DB      01H
RSM41:  DB      01H
RSM42:  DB      01H
RSM43:  DB      03H
RSM44:  DB      03H
RSM45:  DB      03H
RSM46:  DB      03H
RSM47:  DB      03H
RSM48:  DB      03H
RSM49:  DB      03H
RSM50:  DB      03H
RSM51:  DB      03H
RSM52:  DB      03H
RSM53:  DB      03H
RSM54:  DB      03H
RSM55:  DB      03H
RSM56:  DB      03H
RSM57:  DB      03H
RSM58:  DB      03H
RSM59:  DB      03H
RSM60:  DB      03H
RSM61:  DB      03H
RSM62:  DB      03H
RSM63:  DB      03H
RSM64:  DB      03H
RSM65:  DB      03H
RSM66:  DB      03H
RSM67:  DB      03H
RSM68:  DB      03H
RSM69:  DB      03H
RSM70:  DB      03H
RSM71:  DB      03H
RSM72:  DB      03H
RSM73:  DB      03H
RSM74:  DB      03H
RSM75:  DB      03H
RSM76:  DB      03H
RSM77:  DB      03H
RSM78:  DB      03H
RSM79:  DB      03H
RSM80:  DB      03H
RSM81:  DB      03H
RSM82:  DB      03H
RSM83:  DB      03H
RSM84:  DB      03H
RSM85:  DB      03H
RSM86:  DB      03H
RSM87:  DB      03H
RSM88:  DB      03H
RSM89:  DB      03H
RSM90:  DB      03H
RSM91:  DB      03H
RSM92:  DB      03H
RSM93:  DB      03H
RSM94:  DB      03H
RSM95:  DB      03H
RSM96:  DB      03H
RSM97:  DB      03H
RSM98:  DB      03H
RSM99:  DB      03H
RSM100: DB      03H
RSM101: DB      03H
RSM102: DB      03H
RSM103: DB      03H
RSM104: DB      03H
RSM105: DB      03H
RSM106: DB      03H
RSM107: DB      03H
RSM108: DB      03H
RSM109: DB      03H
RSM110: DB      03H
RSM111: DB      03H
RSM112: DB      03H
RSM113: DB      03H
RSM114: DB      03H
RSM115: DB      03H
RSM116: DB      03H
RSM117: DB      03H
RSM118: DB      03H
RSM119: DB      03H
RSM120: DB      03H
RSM121: DB      03H
RSM122: DB      03H
RSM123: DB      03H
RSM124: DB      03H
RSM125: DB      03H
RSM126: DB      03H
        END
